package com.xforceplus.financialsettlement.controller;


/**
 * 用于测试功能，勿删feign客户端
 *
 * @author ultraman
 * @date 2022-01-24
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.Test;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface TestFeignApi {

  /**
   * 通过id查询用于测试功能，勿删
   * @param  id
   * @return R
   */
  @GetMapping("/test/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增用于测试功能，勿删
   * @param test 用于测试功能，勿删
   * @return R
   */
  @PostMapping("/test/add")
  public R save(@RequestBody Test test);

  /**
   * 修改用于测试功能，勿删
   * @param test 用于测试功能，勿删
   * @return R
   */
  @PostMapping("/test/update")
  public R updateById(@RequestBody Test test);

  /**
   * 通过id删除用于测试功能，勿删
   * @param  id
   * @return R
   */
  @DeleteMapping("/test/del/{id}" )
  public R removeById(@PathVariable Long id);

}