package com.xforceplus.financialsettlement.controller;


/**
 * charegeCode基础信息feign客户端
 *
 * @author ultraman
 * @date 2022-03-01
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.ChargeCodePool;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface ChargeCodePoolFeignApi {

  /**
   * 通过id查询charegeCode基础信息
   * @param  id
   * @return R
   */
  @GetMapping("/chargeCodePool/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增charegeCode基础信息
   * @param chargeCodePool charegeCode基础信息
   * @return R
   */
  @PostMapping("/chargeCodePool/add")
  public R save(@RequestBody ChargeCodePool chargeCodePool);

  /**
   * 修改charegeCode基础信息
   * @param chargeCodePool charegeCode基础信息
   * @return R
   */
  @PostMapping("/chargeCodePool/update")
  public R updateById(@RequestBody ChargeCodePool chargeCodePool);

  /**
   * 通过id删除charegeCode基础信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/chargeCodePool/del/{id}" )
  public R removeById(@PathVariable Long id);

}