package com.xforceplus.financialsettlement.controller;


/**
 * 中台分摊记录feign客户端
 *
 * @author ultraman
 * @date 2022-03-14
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.ProductAllocation;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface ProductAllocationFeignApi {

  /**
   * 通过id查询中台分摊记录
   * @param  id
   * @return R
   */
  @GetMapping("/productAllocation/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增中台分摊记录
   * @param productAllocation 中台分摊记录
   * @return R
   */
  @PostMapping("/productAllocation/add")
  public R save(@RequestBody ProductAllocation productAllocation);

  /**
   * 修改中台分摊记录
   * @param productAllocation 中台分摊记录
   * @return R
   */
  @PostMapping("/productAllocation/update")
  public R updateById(@RequestBody ProductAllocation productAllocation);

  /**
   * 通过id删除中台分摊记录
   * @param  id
   * @return R
   */
  @DeleteMapping("/productAllocation/del/{id}" )
  public R removeById(@PathVariable Long id);

}