package com.xforceplus.financialsettlement.controller;


/**
 * 订单feign客户端
 *
 * @author ultraman
 * @date 2022-03-15
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.Order;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface OrderFeignApi {

  /**
   * 通过id查询订单
   * @param  id
   * @return R
   */
  @GetMapping("/order/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增订单
   * @param order 订单
   * @return R
   */
  @PostMapping("/order/add")
  public R save(@RequestBody Order order);

  /**
   * 修改订单
   * @param order 订单
   * @return R
   */
  @PostMapping("/order/update")
  public R updateById(@RequestBody Order order);

  /**
   * 通过id删除订单
   * @param  id
   * @return R
   */
  @DeleteMapping("/order/del/{id}" )
  public R removeById(@PathVariable Long id);

}