package com.xforceplus.financialsettlement.controller;


/**
 * 记录表feign客户端
 *
 * @author ultraman
 * @date 2022-04-13
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.RecordTable;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface RecordTableFeignApi {

  /**
   * 通过id查询记录表
   * @param  id
   * @return R
   */
  @GetMapping("/recordTable/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增记录表
   * @param recordTable 记录表
   * @return R
   */
  @PostMapping("/recordTable/add")
  public R save(@RequestBody RecordTable recordTable);

  /**
   * 修改记录表
   * @param recordTable 记录表
   * @return R
   */
  @PostMapping("/recordTable/update")
  public R updateById(@RequestBody RecordTable recordTable);

  /**
   * 通过id删除记录表
   * @param  id
   * @return R
   */
  @DeleteMapping("/recordTable/del/{id}" )
  public R removeById(@PathVariable Long id);

}