package com.xforceplus.financialsettlement.controller;


/**
 * 结算单明细表-税号feign客户端
 *
 * @author ultraman
 * @date 2022-05-15
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.BillDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface BillDetailFeignApi {

  /**
   * 通过id查询结算单明细表-税号
   * @param  id
   * @return R
   */
  @GetMapping("/billDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增结算单明细表-税号
   * @param billDetail 结算单明细表-税号
   * @return R
   */
  @PostMapping("/billDetail/add")
  public R save(@RequestBody BillDetail billDetail);

  /**
   * 修改结算单明细表-税号
   * @param billDetail 结算单明细表-税号
   * @return R
   */
  @PostMapping("/billDetail/update")
  public R updateById(@RequestBody BillDetail billDetail);

  /**
   * 通过id删除结算单明细表-税号
   * @param  id
   * @return R
   */
  @DeleteMapping("/billDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}