package com.xforceplus.financialsettlement.controller;


/**
 * 用量feign客户端
 *
 * @author ultraman
 * @date 2022-05-19
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.InfoBI;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface InfoBIFeignApi {

  /**
   * 通过id查询用量
   * @param  id
   * @return R
   */
  @GetMapping("/infoBI/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增用量
   * @param infoBI 用量
   * @return R
   */
  @PostMapping("/infoBI/add")
  public R save(@RequestBody InfoBI infoBI);

  /**
   * 修改用量
   * @param infoBI 用量
   * @return R
   */
  @PostMapping("/infoBI/update")
  public R updateById(@RequestBody InfoBI infoBI);

  /**
   * 通过id删除用量
   * @param  id
   * @return R
   */
  @DeleteMapping("/infoBI/del/{id}" )
  public R removeById(@PathVariable Long id);

}