package com.xforceplus.financialsettlement.controller;


/**
 * 财务基础单据feign客户端
 *
 * @author ultraman
 * @date 2022-06-08
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.FinBasicBill;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface FinBasicBillFeignApi {

  /**
   * 通过id查询财务基础单据
   * @param  id
   * @return R
   */
  @GetMapping("/finBasicBill/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增财务基础单据
   * @param finBasicBill 财务基础单据
   * @return R
   */
  @PostMapping("/finBasicBill/add")
  public R save(@RequestBody FinBasicBill finBasicBill);

  /**
   * 修改财务基础单据
   * @param finBasicBill 财务基础单据
   * @return R
   */
  @PostMapping("/finBasicBill/update")
  public R updateById(@RequestBody FinBasicBill finBasicBill);

  /**
   * 通过id删除财务基础单据
   * @param  id
   * @return R
   */
  @DeleteMapping("/finBasicBill/del/{id}" )
  public R removeById(@PathVariable Long id);

}