package com.xforceplus.financialsettlement.controller;


/**
 * 差旅申请单明细feign客户端
 *
 * @author ultraman
 * @date 2022-06-08
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.TravelApplyBillDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface TravelApplyBillDetailFeignApi {

  /**
   * 通过id查询差旅申请单明细
   * @param  id
   * @return R
   */
  @GetMapping("/travelApplyBillDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增差旅申请单明细
   * @param travelApplyBillDetail 差旅申请单明细
   * @return R
   */
  @PostMapping("/travelApplyBillDetail/add")
  public R save(@RequestBody TravelApplyBillDetail travelApplyBillDetail);

  /**
   * 修改差旅申请单明细
   * @param travelApplyBillDetail 差旅申请单明细
   * @return R
   */
  @PostMapping("/travelApplyBillDetail/update")
  public R updateById(@RequestBody TravelApplyBillDetail travelApplyBillDetail);

  /**
   * 通过id删除差旅申请单明细
   * @param  id
   * @return R
   */
  @DeleteMapping("/travelApplyBillDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}