package com.xforceplus.financialsettlement.controller;


/**
 * 差旅报销单明细feign客户端
 *
 * @author ultraman
 * @date 2022-06-08
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.TravelBillDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface TravelBillDetailFeignApi {

  /**
   * 通过id查询差旅报销单明细
   * @param  id
   * @return R
   */
  @GetMapping("/travelBillDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增差旅报销单明细
   * @param travelBillDetail 差旅报销单明细
   * @return R
   */
  @PostMapping("/travelBillDetail/add")
  public R save(@RequestBody TravelBillDetail travelBillDetail);

  /**
   * 修改差旅报销单明细
   * @param travelBillDetail 差旅报销单明细
   * @return R
   */
  @PostMapping("/travelBillDetail/update")
  public R updateById(@RequestBody TravelBillDetail travelBillDetail);

  /**
   * 通过id删除差旅报销单明细
   * @param  id
   * @return R
   */
  @DeleteMapping("/travelBillDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}