package com.xforceplus.financialsettlement.controller;


/**
 * 市内交通报销单明细feign客户端
 *
 * @author ultraman
 * @date 2022-06-08
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.CityBillDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface CityBillDetailFeignApi {

  /**
   * 通过id查询市内交通报销单明细
   * @param  id
   * @return R
   */
  @GetMapping("/cityBillDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增市内交通报销单明细
   * @param cityBillDetail 市内交通报销单明细
   * @return R
   */
  @PostMapping("/cityBillDetail/add")
  public R save(@RequestBody CityBillDetail cityBillDetail);

  /**
   * 修改市内交通报销单明细
   * @param cityBillDetail 市内交通报销单明细
   * @return R
   */
  @PostMapping("/cityBillDetail/update")
  public R updateById(@RequestBody CityBillDetail cityBillDetail);

  /**
   * 通过id删除市内交通报销单明细
   * @param  id
   * @return R
   */
  @DeleteMapping("/cityBillDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}