package com.xforceplus.financialsettlement.controller;


/**
 * 财务基础单据明细feign客户端
 *
 * @author ultraman
 * @date 2022-06-08
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.FinBasicBillDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface FinBasicBillDetailFeignApi {

  /**
   * 通过id查询财务基础单据明细
   * @param  id
   * @return R
   */
  @GetMapping("/finBasicBillDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增财务基础单据明细
   * @param finBasicBillDetail 财务基础单据明细
   * @return R
   */
  @PostMapping("/finBasicBillDetail/add")
  public R save(@RequestBody FinBasicBillDetail finBasicBillDetail);

  /**
   * 修改财务基础单据明细
   * @param finBasicBillDetail 财务基础单据明细
   * @return R
   */
  @PostMapping("/finBasicBillDetail/update")
  public R updateById(@RequestBody FinBasicBillDetail finBasicBillDetail);

  /**
   * 通过id删除财务基础单据明细
   * @param  id
   * @return R
   */
  @DeleteMapping("/finBasicBillDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}