package com.xforceplus.financialsettlement.controller;


/**
 * 合思订单核销单feign客户端
 *
 * @author ultraman
 * @date 2022-06-08
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.HesWriteoffBill;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface HesWriteoffBillFeignApi {

  /**
   * 通过id查询合思订单核销单
   * @param  id
   * @return R
   */
  @GetMapping("/hesWriteoffBill/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增合思订单核销单
   * @param hesWriteoffBill 合思订单核销单
   * @return R
   */
  @PostMapping("/hesWriteoffBill/add")
  public R save(@RequestBody HesWriteoffBill hesWriteoffBill);

  /**
   * 修改合思订单核销单
   * @param hesWriteoffBill 合思订单核销单
   * @return R
   */
  @PostMapping("/hesWriteoffBill/update")
  public R updateById(@RequestBody HesWriteoffBill hesWriteoffBill);

  /**
   * 通过id删除合思订单核销单
   * @param  id
   * @return R
   */
  @DeleteMapping("/hesWriteoffBill/del/{id}" )
  public R removeById(@PathVariable Long id);

}