package com.xforceplus.financialsettlement.controller;


/**
 * 差旅报销单feign客户端
 *
 * @author ultraman
 * @date 2022-06-08
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.TravelReimbursementBill;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface TravelReimbursementBillFeignApi {

  /**
   * 通过id查询差旅报销单
   * @param  id
   * @return R
   */
  @GetMapping("/travelReimbursementBill/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增差旅报销单
   * @param travelReimbursementBill 差旅报销单
   * @return R
   */
  @PostMapping("/travelReimbursementBill/add")
  public R save(@RequestBody TravelReimbursementBill travelReimbursementBill);

  /**
   * 修改差旅报销单
   * @param travelReimbursementBill 差旅报销单
   * @return R
   */
  @PostMapping("/travelReimbursementBill/update")
  public R updateById(@RequestBody TravelReimbursementBill travelReimbursementBill);

  /**
   * 通过id删除差旅报销单
   * @param  id
   * @return R
   */
  @DeleteMapping("/travelReimbursementBill/del/{id}" )
  public R removeById(@PathVariable Long id);

}