package com.xforceplus.financialsettlement.controller;


/**
 * 计费元数据feign客户端
 *
 * @author ultraman
 * @date 2022-06-14
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.ChargeMetaData;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface ChargeMetaDataFeignApi {

  /**
   * 通过id查询计费元数据
   * @param  id
   * @return R
   */
  @GetMapping("/chargeMetaData/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增计费元数据
   * @param chargeMetaData 计费元数据
   * @return R
   */
  @PostMapping("/chargeMetaData/add")
  public R save(@RequestBody ChargeMetaData chargeMetaData);

  /**
   * 修改计费元数据
   * @param chargeMetaData 计费元数据
   * @return R
   */
  @PostMapping("/chargeMetaData/update")
  public R updateById(@RequestBody ChargeMetaData chargeMetaData);

  /**
   * 通过id删除计费元数据
   * @param  id
   * @return R
   */
  @DeleteMapping("/chargeMetaData/del/{id}" )
  public R removeById(@PathVariable Long id);

}