package com.xforceplus.financialsettlement.controller;


/**
 * 产品功能feign客户端
 *
 * @author ultraman
 * @date 2022-06-14
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.ProductFunction;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface ProductFunctionFeignApi {

  /**
   * 通过id查询产品功能
   * @param  id
   * @return R
   */
  @GetMapping("/productFunction/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增产品功能
   * @param productFunction 产品功能
   * @return R
   */
  @PostMapping("/productFunction/add")
  public R save(@RequestBody ProductFunction productFunction);

  /**
   * 修改产品功能
   * @param productFunction 产品功能
   * @return R
   */
  @PostMapping("/productFunction/update")
  public R updateById(@RequestBody ProductFunction productFunction);

  /**
   * 通过id删除产品功能
   * @param  id
   * @return R
   */
  @DeleteMapping("/productFunction/del/{id}" )
  public R removeById(@PathVariable Long id);

}