package com.xforceplus.financialsettlement.controller;


/**
 *  单据同步对象-易快报feign客户端
 *
 * @author ultraman
 * @date 2022-07-12
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.BillSyn;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface BillSynFeignApi {

  /**
   * 通过id查询 单据同步对象-易快报
   * @param  id
   * @return R
   */
  @GetMapping("/billSyn/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增 单据同步对象-易快报
   * @param billSyn  单据同步对象-易快报
   * @return R
   */
  @PostMapping("/billSyn/add")
  public R save(@RequestBody BillSyn billSyn);

  /**
   * 修改 单据同步对象-易快报
   * @param billSyn  单据同步对象-易快报
   * @return R
   */
  @PostMapping("/billSyn/update")
  public R updateById(@RequestBody BillSyn billSyn);

  /**
   * 通过id删除 单据同步对象-易快报
   * @param  id
   * @return R
   */
  @DeleteMapping("/billSyn/del/{id}" )
  public R removeById(@PathVariable Long id);

}