package com.xforceplus.financialsettlement.controller;


/**
 * 服务成本主信息feign客户端
 *
 * @author ultraman
 * @date 2022-07-12
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.ServiceCost;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface ServiceCostFeignApi {

  /**
   * 通过id查询服务成本主信息
   * @param  id
   * @return R
   */
  @GetMapping("/serviceCost/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增服务成本主信息
   * @param serviceCost 服务成本主信息
   * @return R
   */
  @PostMapping("/serviceCost/add")
  public R save(@RequestBody ServiceCost serviceCost);

  /**
   * 修改服务成本主信息
   * @param serviceCost 服务成本主信息
   * @return R
   */
  @PostMapping("/serviceCost/update")
  public R updateById(@RequestBody ServiceCost serviceCost);

  /**
   * 通过id删除服务成本主信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/serviceCost/del/{id}" )
  public R removeById(@PathVariable Long id);

}