package com.xforceplus.financialsettlement.controller;


/**
 * 保管人变更申请单明细feign客户端
 *
 * @author ultraman
 * @date 2022-07-16
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialKeeperChangeBillDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface FinancialKeeperChangeBillDetailFeignApi {

  /**
   * 通过id查询保管人变更申请单明细
   * @param  id
   * @return R
   */
  @GetMapping("/financialKeeperChangeBillDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增保管人变更申请单明细
   * @param financialKeeperChangeBillDetail 保管人变更申请单明细
   * @return R
   */
  @PostMapping("/financialKeeperChangeBillDetail/add")
  public R save(@RequestBody FinancialKeeperChangeBillDetail financialKeeperChangeBillDetail);

  /**
   * 修改保管人变更申请单明细
   * @param financialKeeperChangeBillDetail 保管人变更申请单明细
   * @return R
   */
  @PostMapping("/financialKeeperChangeBillDetail/update")
  public R updateById(@RequestBody FinancialKeeperChangeBillDetail financialKeeperChangeBillDetail);

  /**
   * 通过id删除保管人变更申请单明细
   * @param  id
   * @return R
   */
  @DeleteMapping("/financialKeeperChangeBillDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}