package com.xforceplus.financialsettlement.controller;


/**
 * 团建费报销单feign客户端
 *
 * @author ultraman
 * @date 2022-07-21
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialTeamBuildingBill;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface FinancialTeamBuildingBillFeignApi {

  /**
   * 通过id查询团建费报销单
   * @param  id
   * @return R
   */
  @GetMapping("/financialTeamBuildingBill/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增团建费报销单
   * @param financialTeamBuildingBill 团建费报销单
   * @return R
   */
  @PostMapping("/financialTeamBuildingBill/add")
  public R save(@RequestBody FinancialTeamBuildingBill financialTeamBuildingBill);

  /**
   * 修改团建费报销单
   * @param financialTeamBuildingBill 团建费报销单
   * @return R
   */
  @PostMapping("/financialTeamBuildingBill/update")
  public R updateById(@RequestBody FinancialTeamBuildingBill financialTeamBuildingBill);

  /**
   * 通过id删除团建费报销单
   * @param  id
   * @return R
   */
  @DeleteMapping("/financialTeamBuildingBill/del/{id}" )
  public R removeById(@PathVariable Long id);

}