package com.xforceplus.financialsettlement.controller;


/**
 * 单据发票同步信息-易快报feign客户端
 *
 * @author ultraman
 * @date 2022-08-17
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.BillInvoiceSyn;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface BillInvoiceSynFeignApi {

  /**
   * 通过id查询单据发票同步信息-易快报
   * @param  id
   * @return R
   */
  @GetMapping("/billInvoiceSyn/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增单据发票同步信息-易快报
   * @param billInvoiceSyn 单据发票同步信息-易快报
   * @return R
   */
  @PostMapping("/billInvoiceSyn/add")
  public R save(@RequestBody BillInvoiceSyn billInvoiceSyn);

  /**
   * 修改单据发票同步信息-易快报
   * @param billInvoiceSyn 单据发票同步信息-易快报
   * @return R
   */
  @PostMapping("/billInvoiceSyn/update")
  public R updateById(@RequestBody BillInvoiceSyn billInvoiceSyn);

  /**
   * 通过id删除单据发票同步信息-易快报
   * @param  id
   * @return R
   */
  @DeleteMapping("/billInvoiceSyn/del/{id}" )
  public R removeById(@PathVariable Long id);

}