package com.xforceplus.financialsettlement.controller;


/**
 * 资产的归还申请单明细feign客户端
 *
 * @author ultraman
 * @date 2022-08-17
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialAssetsBackBillDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface FinancialAssetsBackBillDetailFeignApi {

  /**
   * 通过id查询资产的归还申请单明细
   * @param  id
   * @return R
   */
  @GetMapping("/financialAssetsBackBillDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增资产的归还申请单明细
   * @param financialAssetsBackBillDetail 资产的归还申请单明细
   * @return R
   */
  @PostMapping("/financialAssetsBackBillDetail/add")
  public R save(@RequestBody FinancialAssetsBackBillDetail financialAssetsBackBillDetail);

  /**
   * 修改资产的归还申请单明细
   * @param financialAssetsBackBillDetail 资产的归还申请单明细
   * @return R
   */
  @PostMapping("/financialAssetsBackBillDetail/update")
  public R updateById(@RequestBody FinancialAssetsBackBillDetail financialAssetsBackBillDetail);

  /**
   * 通过id删除资产的归还申请单明细
   * @param  id
   * @return R
   */
  @DeleteMapping("/financialAssetsBackBillDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}