package com.xforceplus.financialsettlement.controller;


/**
 * 结算表明细与发票关系feign客户端
 *
 * @author ultraman
 * @date 2022-08-17
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.SettlementDetailAndInvoiceRelation;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface SettlementDetailAndInvoiceRelationFeignApi {

  /**
   * 通过id查询结算表明细与发票关系
   * @param  id
   * @return R
   */
  @GetMapping("/settlementDetailAndInvoiceRelation/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增结算表明细与发票关系
   * @param settlementDetailAndInvoiceRelation 结算表明细与发票关系
   * @return R
   */
  @PostMapping("/settlementDetailAndInvoiceRelation/add")
  public R save(@RequestBody SettlementDetailAndInvoiceRelation settlementDetailAndInvoiceRelation);

  /**
   * 修改结算表明细与发票关系
   * @param settlementDetailAndInvoiceRelation 结算表明细与发票关系
   * @return R
   */
  @PostMapping("/settlementDetailAndInvoiceRelation/update")
  public R updateById(@RequestBody SettlementDetailAndInvoiceRelation settlementDetailAndInvoiceRelation);

  /**
   * 通过id删除结算表明细与发票关系
   * @param  id
   * @return R
   */
  @DeleteMapping("/settlementDetailAndInvoiceRelation/del/{id}" )
  public R removeById(@PathVariable Long id);

}