package com.xforceplus.financialsettlement.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2023-01-09
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialShareInfo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface FinancialShareInfoFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/financialShareInfo/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param financialShareInfo ${table.comment}
   * @return R
   */
  @PostMapping("/financialShareInfo/add")
  public R save(@RequestBody FinancialShareInfo financialShareInfo);

  /**
   * 修改${table.comment}
   * @param financialShareInfo ${table.comment}
   * @return R
   */
  @PostMapping("/financialShareInfo/update")
  public R updateById(@RequestBody FinancialShareInfo financialShareInfo);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/financialShareInfo/del/{id}" )
  public R removeById(@PathVariable Long id);

}