package com.xforceplus.financialsettlement.controller;


/**
 * 项目基础信息feign客户端
 *
 * @author ultraman
 * @date 2023-06-12
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.ProjectBasicInfo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface ProjectBasicInfoFeignApi {

  /**
   * 通过id查询项目基础信息
   * @param  id
   * @return R
   */
  @GetMapping("/projectBasicInfo/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增项目基础信息
   * @param projectBasicInfo 项目基础信息
   * @return R
   */
  @PostMapping("/projectBasicInfo/add")
  public R save(@RequestBody ProjectBasicInfo projectBasicInfo);

  /**
   * 修改项目基础信息
   * @param projectBasicInfo 项目基础信息
   * @return R
   */
  @PostMapping("/projectBasicInfo/update")
  public R updateById(@RequestBody ProjectBasicInfo projectBasicInfo);

  /**
   * 通过id删除项目基础信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/projectBasicInfo/del/{id}" )
  public R removeById(@PathVariable Long id);

}