package com.xforceplus.financialsettlement.controller;


/**
 * 结算业务用量统计表feign客户端
 *
 * @author ultraman
 * @date 2023-06-12
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.StatisticBusinessUsage;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface StatisticBusinessUsageFeignApi {

  /**
   * 通过id查询结算业务用量统计表
   * @param  id
   * @return R
   */
  @GetMapping("/statisticBusinessUsage/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增结算业务用量统计表
   * @param statisticBusinessUsage 结算业务用量统计表
   * @return R
   */
  @PostMapping("/statisticBusinessUsage/add")
  public R save(@RequestBody StatisticBusinessUsage statisticBusinessUsage);

  /**
   * 修改结算业务用量统计表
   * @param statisticBusinessUsage 结算业务用量统计表
   * @return R
   */
  @PostMapping("/statisticBusinessUsage/update")
  public R updateById(@RequestBody StatisticBusinessUsage statisticBusinessUsage);

  /**
   * 通过id删除结算业务用量统计表
   * @param  id
   * @return R
   */
  @DeleteMapping("/statisticBusinessUsage/del/{id}" )
  public R removeById(@PathVariable Long id);

}