package com.xforceplus.financialsettlement.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2023-06-12
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.UntreatedOrderInfo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface UntreatedOrderInfoFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/untreatedOrderInfo/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param untreatedOrderInfo ${table.comment}
   * @return R
   */
  @PostMapping("/untreatedOrderInfo/add")
  public R save(@RequestBody UntreatedOrderInfo untreatedOrderInfo);

  /**
   * 修改${table.comment}
   * @param untreatedOrderInfo ${table.comment}
   * @return R
   */
  @PostMapping("/untreatedOrderInfo/update")
  public R updateById(@RequestBody UntreatedOrderInfo untreatedOrderInfo);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/untreatedOrderInfo/del/{id}" )
  public R removeById(@PathVariable Long id);

}