package com.xforceplus.financialsettlement.controller;


/**
 * 资产调拨转移申请单feign客户端
 *
 * @author ultraman
 * @date 2023-10-27
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialAssetsTransferBill;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface FinancialAssetsTransferBillFeignApi {

  /**
   * 通过id查询资产调拨转移申请单
   * @param  id
   * @return R
   */
  @GetMapping("/financialAssetsTransferBill/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增资产调拨转移申请单
   * @param financialAssetsTransferBill 资产调拨转移申请单
   * @return R
   */
  @PostMapping("/financialAssetsTransferBill/add")
  public R save(@RequestBody FinancialAssetsTransferBill financialAssetsTransferBill);

  /**
   * 修改资产调拨转移申请单
   * @param financialAssetsTransferBill 资产调拨转移申请单
   * @return R
   */
  @PostMapping("/financialAssetsTransferBill/update")
  public R updateById(@RequestBody FinancialAssetsTransferBill financialAssetsTransferBill);

  /**
   * 通过id删除资产调拨转移申请单
   * @param  id
   * @return R
   */
  @DeleteMapping("/financialAssetsTransferBill/del/{id}" )
  public R removeById(@PathVariable Long id);

}