package com.xforceplus.financialsettlement.controller;


/**
 * 个人借款归还单feign客户端
 *
 * @author ultraman
 * @date 2023-10-27
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialPersonLoanBackBill;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface FinancialPersonLoanBackBillFeignApi {

  /**
   * 通过id查询个人借款归还单
   * @param  id
   * @return R
   */
  @GetMapping("/financialPersonLoanBackBill/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增个人借款归还单
   * @param financialPersonLoanBackBill 个人借款归还单
   * @return R
   */
  @PostMapping("/financialPersonLoanBackBill/add")
  public R save(@RequestBody FinancialPersonLoanBackBill financialPersonLoanBackBill);

  /**
   * 修改个人借款归还单
   * @param financialPersonLoanBackBill 个人借款归还单
   * @return R
   */
  @PostMapping("/financialPersonLoanBackBill/update")
  public R updateById(@RequestBody FinancialPersonLoanBackBill financialPersonLoanBackBill);

  /**
   * 通过id删除个人借款归还单
   * @param  id
   * @return R
   */
  @DeleteMapping("/financialPersonLoanBackBill/del/{id}" )
  public R removeById(@PathVariable Long id);

}