package com.xforceplus.financialsettlement.controller;


/**
 * 资产的领用及更换申请单feign客户端
 *
 * @author ultraman
 * @date 2023-11-21
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialAssetsBill;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface FinancialAssetsBillFeignApi {

  /**
   * 通过id查询资产的领用及更换申请单
   * @param  id
   * @return R
   */
  @GetMapping("/financialAssetsBill/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增资产的领用及更换申请单
   * @param financialAssetsBill 资产的领用及更换申请单
   * @return R
   */
  @PostMapping("/financialAssetsBill/add")
  public R save(@RequestBody FinancialAssetsBill financialAssetsBill);

  /**
   * 修改资产的领用及更换申请单
   * @param financialAssetsBill 资产的领用及更换申请单
   * @return R
   */
  @PostMapping("/financialAssetsBill/update")
  public R updateById(@RequestBody FinancialAssetsBill financialAssetsBill);

  /**
   * 通过id删除资产的领用及更换申请单
   * @param  id
   * @return R
   */
  @DeleteMapping("/financialAssetsBill/del/{id}" )
  public R removeById(@PathVariable Long id);

}