package com.xforceplus.financialsettlement.controller;


/**
 * 退款申请单「其他」明细feign客户端
 *
 * @author ultraman
 * @date 2024-03-04
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialRfOtherDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface FinancialRfOtherDetailFeignApi {

  /**
   * 通过id查询退款申请单「其他」明细
   * @param  id
   * @return R
   */
  @GetMapping("/financialRfOtherDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增退款申请单「其他」明细
   * @param financialRfOtherDetail 退款申请单「其他」明细
   * @return R
   */
  @PostMapping("/financialRfOtherDetail/add")
  public R save(@RequestBody FinancialRfOtherDetail financialRfOtherDetail);

  /**
   * 修改退款申请单「其他」明细
   * @param financialRfOtherDetail 退款申请单「其他」明细
   * @return R
   */
  @PostMapping("/financialRfOtherDetail/update")
  public R updateById(@RequestBody FinancialRfOtherDetail financialRfOtherDetail);

  /**
   * 通过id删除退款申请单「其他」明细
   * @param  id
   * @return R
   */
  @DeleteMapping("/financialRfOtherDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}