package com.xforceplus.financialsettlement.controller;


/**
 * feign客户端
 *
 * @author ultraman
 * @date 2024-03-04
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.YkbHsOrder;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface YkbHsOrderFeignApi {

  /**
   * 通过id查询
   * @param  id
   * @return R
   */
  @GetMapping("/ykbHsOrder/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增
   * @param ykbHsOrder 
   * @return R
   */
  @PostMapping("/ykbHsOrder/add")
  public R save(@RequestBody YkbHsOrder ykbHsOrder);

  /**
   * 修改
   * @param ykbHsOrder 
   * @return R
   */
  @PostMapping("/ykbHsOrder/update")
  public R updateById(@RequestBody YkbHsOrder ykbHsOrder);

  /**
   * 通过id删除
   * @param  id
   * @return R
   */
  @DeleteMapping("/ykbHsOrder/del/{id}" )
  public R removeById(@PathVariable Long id);

}