package com.xforceplus.financialsettlement.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2024-03-04
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.MemberCost;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface MemberCostFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/memberCost/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param memberCost ${table.comment}
   * @return R
   */
  @PostMapping("/memberCost/add")
  public R save(@RequestBody MemberCost memberCost);

  /**
   * 修改${table.comment}
   * @param memberCost ${table.comment}
   * @return R
   */
  @PostMapping("/memberCost/update")
  public R updateById(@RequestBody MemberCost memberCost);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/memberCost/del/{id}" )
  public R removeById(@PathVariable Long id);

}