package com.xforceplus.financialsettlement.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2024-03-11
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.ContractTaxNoDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface ContractTaxNoDetailFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/contractTaxNoDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param contractTaxNoDetail ${table.comment}
   * @return R
   */
  @PostMapping("/contractTaxNoDetail/add")
  public R save(@RequestBody ContractTaxNoDetail contractTaxNoDetail);

  /**
   * 修改${table.comment}
   * @param contractTaxNoDetail ${table.comment}
   * @return R
   */
  @PostMapping("/contractTaxNoDetail/update")
  public R updateById(@RequestBody ContractTaxNoDetail contractTaxNoDetail);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/contractTaxNoDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}