package com.xforceplus.financialsettlement.controller;


/**
 * 成本表feign客户端
 *
 * @author ultraman
 * @date 2024-03-11
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.Costing;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface CostingFeignApi {

  /**
   * 通过id查询成本表
   * @param  id
   * @return R
   */
  @GetMapping("/costing/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增成本表
   * @param costing 成本表
   * @return R
   */
  @PostMapping("/costing/add")
  public R save(@RequestBody Costing costing);

  /**
   * 修改成本表
   * @param costing 成本表
   * @return R
   */
  @PostMapping("/costing/update")
  public R updateById(@RequestBody Costing costing);

  /**
   * 通过id删除成本表
   * @param  id
   * @return R
   */
  @DeleteMapping("/costing/del/{id}" )
  public R removeById(@PathVariable Long id);

}