package com.xforceplus.financialsettlement.controller;


/**
 * 日常报销单明细feign客户端
 *
 * @author ultraman
 * @date 2024-03-11
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialDailyBillDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface FinancialDailyBillDetailFeignApi {

  /**
   * 通过id查询日常报销单明细
   * @param  id
   * @return R
   */
  @GetMapping("/financialDailyBillDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增日常报销单明细
   * @param financialDailyBillDetail 日常报销单明细
   * @return R
   */
  @PostMapping("/financialDailyBillDetail/add")
  public R save(@RequestBody FinancialDailyBillDetail financialDailyBillDetail);

  /**
   * 修改日常报销单明细
   * @param financialDailyBillDetail 日常报销单明细
   * @return R
   */
  @PostMapping("/financialDailyBillDetail/update")
  public R updateById(@RequestBody FinancialDailyBillDetail financialDailyBillDetail);

  /**
   * 通过id删除日常报销单明细
   * @param  id
   * @return R
   */
  @DeleteMapping("/financialDailyBillDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}