package com.xforceplus.financialsettlement.controller;


/**
 * 团建费报销单明细feign客户端
 *
 * @author ultraman
 * @date 2022-07-11
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialTeamBuildingBillDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface FinancialTeamBuildingBillDetailFeignApi {

  /**
   * 通过id查询团建费报销单明细
   * @param  id
   * @return R
   */
  @GetMapping("/financialTeamBuildingBillDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增团建费报销单明细
   * @param financialTeamBuildingBillDetail 团建费报销单明细
   * @return R
   */
  @PostMapping("/financialTeamBuildingBillDetail/add")
  public R save(@RequestBody FinancialTeamBuildingBillDetail financialTeamBuildingBillDetail);

  /**
   * 修改团建费报销单明细
   * @param financialTeamBuildingBillDetail 团建费报销单明细
   * @return R
   */
  @PostMapping("/financialTeamBuildingBillDetail/update")
  public R updateById(@RequestBody FinancialTeamBuildingBillDetail financialTeamBuildingBillDetail);

  /**
   * 通过id删除团建费报销单明细
   * @param  id
   * @return R
   */
  @DeleteMapping("/financialTeamBuildingBillDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}