package com.xforceplus.financialsettlement.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2022-07-11
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.PaymentConfig;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface PaymentConfigFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/paymentConfig/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param paymentConfig ${table.comment}
   * @return R
   */
  @PostMapping("/paymentConfig/add")
  public R save(@RequestBody PaymentConfig paymentConfig);

  /**
   * 修改${table.comment}
   * @param paymentConfig ${table.comment}
   * @return R
   */
  @PostMapping("/paymentConfig/update")
  public R updateById(@RequestBody PaymentConfig paymentConfig);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/paymentConfig/del/{id}" )
  public R removeById(@PathVariable Long id);

}