package com.xforceplus.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-07-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class IncomeDetail implements Serializable {

  private static final long serialVersionUID=1L;

  @TableField("groupName")
  private String groupName;

  private String module;

  private String function;

  private String contract;

  @TableField("projectNo")
  private String projectNo;

  private String project;

  @TableField("useGroup")
  private String useGroup;

  @TableField("userTax")
  private String userTax;

  private String product;

  private BigDecimal number;

  @TableField("taxNo")
  private Long taxNo;

  @TableField("unitPriceNoTax")
  private BigDecimal unitPriceNoTax;

  @TableField("settlementStartDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime settlementStartDate;

  @TableField("settlementEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime settlementEndDate;

  @TableField("settlementMoney")
  private BigDecimal settlementMoney;

  @TableField("priorPeriodIncome")
  private BigDecimal priorPeriodIncome;

  @TableField("curIncome")
  private BigDecimal curIncome;

  @TableField("costUnitPrice")
  private BigDecimal costUnitPrice;

  @TableField("shouldPaymentMoney")
  private BigDecimal shouldPaymentMoney;

  @TableField("priorPeriodCost")
  private BigDecimal priorPeriodCost;

  @TableField("curCost")
  private String curCost;

  @TableField("costTypeMark")
  private String costTypeMark;

  @TableField("supplierRenewalMark")
  private String supplierRenewalMark;

  @TableField("incrementType")
  private String incrementType;

  @TableField("stopType")
  private String stopType;

  @TableField("incomeType")
  private String incomeType;

  private String comments;

  @TableField("mRR")
  private String mRR;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  @TableField("curDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime curDate;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("groupName", groupName);
      map.put("module", module);
      map.put("function", function);
      map.put("contract", contract);
      map.put("projectNo", projectNo);
      map.put("project", project);
      map.put("useGroup", useGroup);
      map.put("userTax", userTax);
      map.put("product", product);
      map.put("number", number);
      map.put("taxNo", taxNo);
      map.put("unitPriceNoTax", unitPriceNoTax);
      map.put("settlementStartDate", BocpGenUtils.toTimestamp(settlementStartDate));
      map.put("settlementEndDate", BocpGenUtils.toTimestamp(settlementEndDate));
      map.put("settlementMoney", settlementMoney);
      map.put("priorPeriodIncome", priorPeriodIncome);
      map.put("curIncome", curIncome);
      map.put("costUnitPrice", costUnitPrice);
      map.put("shouldPaymentMoney", shouldPaymentMoney);
      map.put("priorPeriodCost", priorPeriodCost);
      map.put("curCost", curCost);
      map.put("costTypeMark", costTypeMark);
      map.put("supplierRenewalMark", supplierRenewalMark);
      map.put("incrementType", incrementType);
      map.put("stopType", stopType);
      map.put("incomeType", incomeType);
      map.put("comments", comments);
      map.put("mRR", mRR);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("curDate", BocpGenUtils.toTimestamp(curDate));
      return map;
  }

  public static IncomeDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    IncomeDetail entity = new IncomeDetail();
    if(map.containsKey("groupName")) {
      Object obj = map.get("groupName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("module")) {
      Object obj = map.get("module");
      if(obj != null) {
        if(obj instanceof String){
          entity.setModule((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("function")) {
      Object obj = map.get("function");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFunction((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contract")) {
      Object obj = map.get("contract");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContract((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectNo")) {
      Object obj = map.get("projectNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("project")) {
      Object obj = map.get("project");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProject((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("useGroup")) {
      Object obj = map.get("useGroup");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUseGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("userTax")) {
      Object obj = map.get("userTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUserTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product")) {
      Object obj = map.get("product");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProduct((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("number")) {
      Object obj = map.get("number");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setNumber((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setNumber(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setNumber(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setNumber(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setNumber(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxNo")) {
      Object obj = map.get("taxNo");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTaxNo((Long)obj);
        } else if(obj instanceof String) {
          entity.setTaxNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTaxNo(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceNoTax")) {
      Object obj = map.get("unitPriceNoTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPriceNoTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPriceNoTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPriceNoTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUnitPriceNoTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPriceNoTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("settlementStartDate")) {
      Object obj = map.get("settlementStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSettlementStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSettlementStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSettlementStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSettlementStartDate(null);
      }
    }
    if(map.containsKey("settlementEndDate")) {
      Object obj = map.get("settlementEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSettlementEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSettlementEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSettlementEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSettlementEndDate(null);
      }
    }
    if(map.containsKey("settlementMoney")) {
      Object obj = map.get("settlementMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSettlementMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSettlementMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSettlementMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setSettlementMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSettlementMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("priorPeriodIncome")) {
      Object obj = map.get("priorPeriodIncome");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPriorPeriodIncome((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPriorPeriodIncome(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPriorPeriodIncome(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPriorPeriodIncome(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPriorPeriodIncome(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("curIncome")) {
      Object obj = map.get("curIncome");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCurIncome((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCurIncome(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCurIncome(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCurIncome(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCurIncome(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("costUnitPrice")) {
      Object obj = map.get("costUnitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCostUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCostUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCostUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCostUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCostUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("shouldPaymentMoney")) {
      Object obj = map.get("shouldPaymentMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setShouldPaymentMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setShouldPaymentMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setShouldPaymentMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setShouldPaymentMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setShouldPaymentMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("priorPeriodCost")) {
      Object obj = map.get("priorPeriodCost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPriorPeriodCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPriorPeriodCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPriorPeriodCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPriorPeriodCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPriorPeriodCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("curCost")) {
      Object obj = map.get("curCost");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurCost((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costTypeMark")) {
      Object obj = map.get("costTypeMark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostTypeMark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierRenewalMark")) {
      Object obj = map.get("supplierRenewalMark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSupplierRenewalMark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("incrementType")) {
      Object obj = map.get("incrementType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIncrementType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("stopType")) {
      Object obj = map.get("stopType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStopType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("incomeType")) {
      Object obj = map.get("incomeType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIncomeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("comments")) {
      Object obj = map.get("comments");
      if(obj != null) {
        if(obj instanceof String){
          entity.setComments((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mRR")) {
      Object obj = map.get("mRR");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMRR((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("curDate")) {
      Object obj = map.get("curDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCurDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCurDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCurDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCurDate(null);
      }
    }
    return entity;
  }
}
