package com.xforceplus.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-07-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SettlementData implements Serializable {

  private static final long serialVersionUID=1L;

  @TableField("contractNo")
  private String contractNo;

  @TableField("projectName")
  private String projectName;

  @TableField("statementNo")
  private String statementNo;

  @TableField("useCompanyName")
  private String useCompanyName;

  @TableField("useCompanyTax")
  private String useCompanyTax;

  private String product;

  private String type;

  @TableField("chargeType")
  private String chargeType;

  private String nature;

  @TableField("unitPriceWithoutTax")
  private BigDecimal unitPriceWithoutTax;

  @TableField("taxRate")
  private BigDecimal taxRate;

  private BigDecimal count;

  @TableField("chargeUnit")
  private String chargeUnit;

  @TableField("incomeType")
  private String incomeType;

  @TableField("checkDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime checkDate;

  private String cycle;

  @TableField("settlementStartDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime settlementStartDate;

  @TableField("settlementEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime settlementEndDate;

  @TableField("statementCreateDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime statementCreateDate;

  @TableField("allSettlementAmountWithoutTax")
  private BigDecimal allSettlementAmountWithoutTax;

  @TableField("allSettlementAmountWithTax")
  private BigDecimal allSettlementAmountWithTax;

  @TableField("invoiceCompanyName")
  private String invoiceCompanyName;

  @TableField("invoiceCompanyTax")
  private String invoiceCompanyTax;

  @TableField("invoiceDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime invoiceDate;

  @TableField("invoiceAmountWithoutTax")
  private BigDecimal invoiceAmountWithoutTax;

  @TableField("invoiceAmountWithTax")
  private BigDecimal invoiceAmountWithTax;

  @TableField("paymentDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paymentDate;

  @TableField("paymentAmount")
  private BigDecimal paymentAmount;

  @TableField("paymentCompany")
  private String paymentCompany;

  @TableField("statementStatus")
  private String statementStatus;

  @TableField("invoiceStatus")
  private String invoiceStatus;

  @TableField("paymentStatus")
  private String paymentStatus;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("contractNo", contractNo);
      map.put("projectName", projectName);
      map.put("statementNo", statementNo);
      map.put("useCompanyName", useCompanyName);
      map.put("useCompanyTax", useCompanyTax);
      map.put("product", product);
      map.put("type", type);
      map.put("chargeType", chargeType);
      map.put("nature", nature);
      map.put("unitPriceWithoutTax", unitPriceWithoutTax);
      map.put("taxRate", taxRate);
      map.put("count", count);
      map.put("chargeUnit", chargeUnit);
      map.put("incomeType", incomeType);
      map.put("checkDate", BocpGenUtils.toTimestamp(checkDate));
      map.put("cycle", cycle);
      map.put("settlementStartDate", BocpGenUtils.toTimestamp(settlementStartDate));
      map.put("settlementEndDate", BocpGenUtils.toTimestamp(settlementEndDate));
      map.put("statementCreateDate", BocpGenUtils.toTimestamp(statementCreateDate));
      map.put("allSettlementAmountWithoutTax", allSettlementAmountWithoutTax);
      map.put("allSettlementAmountWithTax", allSettlementAmountWithTax);
      map.put("invoiceCompanyName", invoiceCompanyName);
      map.put("invoiceCompanyTax", invoiceCompanyTax);
      map.put("invoiceDate", BocpGenUtils.toTimestamp(invoiceDate));
      map.put("invoiceAmountWithoutTax", invoiceAmountWithoutTax);
      map.put("invoiceAmountWithTax", invoiceAmountWithTax);
      map.put("paymentDate", BocpGenUtils.toTimestamp(paymentDate));
      map.put("paymentAmount", paymentAmount);
      map.put("paymentCompany", paymentCompany);
      map.put("statementStatus", statementStatus);
      map.put("invoiceStatus", invoiceStatus);
      map.put("paymentStatus", paymentStatus);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static SettlementData fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    SettlementData entity = new SettlementData();
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("statementNo")) {
      Object obj = map.get("statementNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("useCompanyName")) {
      Object obj = map.get("useCompanyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUseCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("useCompanyTax")) {
      Object obj = map.get("useCompanyTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUseCompanyTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product")) {
      Object obj = map.get("product");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProduct((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("type")) {
      Object obj = map.get("type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeType")) {
      Object obj = map.get("chargeType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("nature")) {
      Object obj = map.get("nature");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNature((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceWithoutTax")) {
      Object obj = map.get("unitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("count")) {
      Object obj = map.get("count");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("chargeUnit")) {
      Object obj = map.get("chargeUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("incomeType")) {
      Object obj = map.get("incomeType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIncomeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkDate")) {
      Object obj = map.get("checkDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCheckDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCheckDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCheckDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCheckDate(null);
      }
    }
    if(map.containsKey("cycle")) {
      Object obj = map.get("cycle");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCycle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementStartDate")) {
      Object obj = map.get("settlementStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSettlementStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSettlementStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSettlementStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSettlementStartDate(null);
      }
    }
    if(map.containsKey("settlementEndDate")) {
      Object obj = map.get("settlementEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSettlementEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSettlementEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSettlementEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSettlementEndDate(null);
      }
    }
    if(map.containsKey("statementCreateDate")) {
      Object obj = map.get("statementCreateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStatementCreateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStatementCreateDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setStatementCreateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStatementCreateDate(null);
      }
    }
    if(map.containsKey("allSettlementAmountWithoutTax")) {
      Object obj = map.get("allSettlementAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAllSettlementAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAllSettlementAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAllSettlementAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAllSettlementAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAllSettlementAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("allSettlementAmountWithTax")) {
      Object obj = map.get("allSettlementAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAllSettlementAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAllSettlementAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAllSettlementAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAllSettlementAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAllSettlementAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCompanyName")) {
      Object obj = map.get("invoiceCompanyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCompanyTax")) {
      Object obj = map.get("invoiceCompanyTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCompanyTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceDate")) {
      Object obj = map.get("invoiceDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setInvoiceDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInvoiceDate(null);
      }
    }
    if(map.containsKey("invoiceAmountWithoutTax")) {
      Object obj = map.get("invoiceAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInvoiceAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmountWithTax")) {
      Object obj = map.get("invoiceAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInvoiceAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paymentDate")) {
      Object obj = map.get("paymentDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaymentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPaymentDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPaymentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaymentDate(null);
      }
    }
    if(map.containsKey("paymentAmount")) {
      Object obj = map.get("paymentAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPaymentAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPaymentAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPaymentAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPaymentAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPaymentAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paymentCompany")) {
      Object obj = map.get("paymentCompany");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentCompany((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("statementStatus")) {
      Object obj = map.get("statementStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatementStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceStatus")) {
      Object obj = map.get("invoiceStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentStatus")) {
      Object obj = map.get("paymentStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
