package com.xforceplus.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 计费维度
 * </p>
 *
 * @author ultraman
 * @since 2021-07-27
 */
public enum ChargeDimension {

    _0("0", "税号/年"),
    _1("1", "张/税号"),
    _2("2", "次/税号"),
    _3("3", "集团/年"),
    _4("4", "张/集团"),
    _5("5", "次/集团"),
    _6("6", "台"),
    _7("7", "个"),
    _8("8", "次"),
    _9("9", "对"),
    _10("10", "套"),
    _11("11", "年"),
    _12("12", "人天"),
    _13("13", "个/年"),
    _14("14", "台/年");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ChargeDimension(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeDimension fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            case "14":
                return _14;
            default:
                return null;
        }
    }
}
