package com.xforceplus.financialsettlement.metadata;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.xforceplus.ultraman.bocp.gen.typed.TypedField;


/**
* <p>
    * 
    * </p>
*
* @author ultraman
* @since 2021-07-27
*/

public class EntityMeta {

    public interface ChargeMetaData {
        static Long id() {
            return 1414504703901081602L;
        }
        static String code() {
            return "chargeMetaData";
        }
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> GROUP = new TypedField<>(String.class, "group");
        TypedField<String> TAXNO = new TypedField<>(String.class, "taxNo");
        TypedField<LocalDateTime> CHARGESTARTDATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGEENDDATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<Long> MONTH = new TypedField<>(Long.class, "month");
        TypedField<String> CHARGEDIMENSION = new TypedField<>(String.class, "chargeDimension");
        TypedField<BigDecimal> AMOUNTWITHOUTTAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<String> PAYWAY = new TypedField<>(String.class, "payWay");
        TypedField<String> USAGE = new TypedField<>(String.class, "usage");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<String> COMPANYNAME = new TypedField<>(String.class, "companyName");
        TypedField<String> CYCLE = new TypedField<>(String.class, "cycle");
        TypedField<String> SHOP = new TypedField<>(String.class, "shop");
        TypedField<String> REGION = new TypedField<>(String.class, "region");
        TypedField<String> CITY = new TypedField<>(String.class, "city");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> WARRANTY = new TypedField<>(String.class, "warranty");
        TypedField<String> INCOMETYPE = new TypedField<>(String.class, "incomeType");
    }

    public interface IncomeDetail {
        static Long id() {
            return 1414505887512698881L;
        }
        static String code() {
            return "incomeDetail";
        }
        TypedField<String> GROUPNAME = new TypedField<>(String.class, "groupName");
        TypedField<String> MODULE = new TypedField<>(String.class, "module");
        TypedField<String> FUNCTION = new TypedField<>(String.class, "function");
        TypedField<String> CONTRACT = new TypedField<>(String.class, "contract");
        TypedField<String> PROJECTNO = new TypedField<>(String.class, "projectNo");
        TypedField<String> PROJECT = new TypedField<>(String.class, "project");
        TypedField<String> USEGROUP = new TypedField<>(String.class, "useGroup");
        TypedField<String> USERTAX = new TypedField<>(String.class, "userTax");
        TypedField<String> PRODUCT = new TypedField<>(String.class, "product");
        TypedField<BigDecimal> NUMBER = new TypedField<>(BigDecimal.class, "number");
        TypedField<Long> TAXNO = new TypedField<>(Long.class, "taxNo");
        TypedField<BigDecimal> UNITPRICENOTAX = new TypedField<>(BigDecimal.class, "unitPriceNoTax");
        TypedField<LocalDateTime> SETTLEMENTSTARTDATE = new TypedField<>(LocalDateTime.class, "settlementStartDate");
        TypedField<LocalDateTime> SETTLEMENTENDDATE = new TypedField<>(LocalDateTime.class, "settlementEndDate");
        TypedField<BigDecimal> SETTLEMENTMONEY = new TypedField<>(BigDecimal.class, "settlementMoney");
        TypedField<BigDecimal> PRIORPERIODINCOME = new TypedField<>(BigDecimal.class, "priorPeriodIncome");
        TypedField<BigDecimal> CURINCOME = new TypedField<>(BigDecimal.class, "curIncome");
        TypedField<BigDecimal> COSTUNITPRICE = new TypedField<>(BigDecimal.class, "costUnitPrice");
        TypedField<BigDecimal> SHOULDPAYMENTMONEY = new TypedField<>(BigDecimal.class, "shouldPaymentMoney");
        TypedField<BigDecimal> PRIORPERIODCOST = new TypedField<>(BigDecimal.class, "priorPeriodCost");
        TypedField<String> CURCOST = new TypedField<>(String.class, "curCost");
        TypedField<String> COSTTYPEMARK = new TypedField<>(String.class, "costTypeMark");
        TypedField<String> SUPPLIERRENEWALMARK = new TypedField<>(String.class, "supplierRenewalMark");
        TypedField<String> INCREMENTTYPE = new TypedField<>(String.class, "incrementType");
        TypedField<String> STOPTYPE = new TypedField<>(String.class, "stopType");
        TypedField<String> INCOMETYPE = new TypedField<>(String.class, "incomeType");
        TypedField<String> COMMENTS = new TypedField<>(String.class, "comments");
        TypedField<String> MRR = new TypedField<>(String.class, "mRR");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> CURDATE = new TypedField<>(LocalDateTime.class, "curDate");
    }

    public interface Costing {
        static Long id() {
            return 1415207897100840961L;
        }
        static String code() {
            return "costing";
        }
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "charge_code");
        TypedField<String> PRODUCT_PHASE = new TypedField<>(String.class, "product_phase");
        TypedField<String> CHARGE_BELONG = new TypedField<>(String.class, "charge_belong");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "charge_type");
        TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "data_source");
        TypedField<BigDecimal> CHARGE_MONEY = new TypedField<>(BigDecimal.class, "charge_money");
        TypedField<String> DEPARTMENT_NAME = new TypedField<>(String.class, "department_name");
        TypedField<String> DEPARTMENT_CODE = new TypedField<>(String.class, "department_code");
        TypedField<String> SERVICE_CODE = new TypedField<>(String.class, "service_code");
        TypedField<String> SERVICE_NAME = new TypedField<>(String.class, "service_name");
        TypedField<String> SUBMIT_STATUS = new TypedField<>(String.class, "submit_status");
        TypedField<LocalDateTime> OCCURRENCE_TIME = new TypedField<>(LocalDateTime.class, "occurrence_time");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface ChargeCode {
        static Long id() {
            return 1415208266803572738L;
        }
        static String code() {
            return "chargeCode";
        }
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "product_code");
        TypedField<String> CHARGE_BELONG_CODE = new TypedField<>(String.class, "charge_belong_code");
        TypedField<String> CHARGE_BELONG = new TypedField<>(String.class, "charge_belong");
        TypedField<String> SOLUTION_TYPE = new TypedField<>(String.class, "solution_type");
        TypedField<String> PROFESSION = new TypedField<>(String.class, "profession");
        TypedField<String> ACTIVITY_TYPE = new TypedField<>(String.class, "activity_type");
        TypedField<String> REGION = new TypedField<>(String.class, "region");
        TypedField<String> SALE_TEAM = new TypedField<>(String.class, "sale_team");
        TypedField<String> PROJECT_CODE = new TypedField<>(String.class, "project_code");
        TypedField<String> SOLUTION_PHASE = new TypedField<>(String.class, "solution_phase");
        TypedField<String> CUSTOMER_CODE = new TypedField<>(String.class, "customer_code");
        TypedField<String> CLASSIFICATION = new TypedField<>(String.class, "classification");
        TypedField<String> PRODUCT_PHASE = new TypedField<>(String.class, "product_phase");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface ProjectBasicInfo {
        static Long id() {
            return 1415208663073026050L;
        }
        static String code() {
            return "projectBasicInfo";
        }
        TypedField<String> PROJECT_CODE = new TypedField<>(String.class, "project_code");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "project_name");
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<String> TENTANT_CODE = new TypedField<>(String.class, "tentant_code");
        TypedField<String> TENTANT_NAME = new TypedField<>(String.class, "tentant_name");
        TypedField<String> PRODUCT_MODEL = new TypedField<>(String.class, "product_model");
        TypedField<BigDecimal> COUNT = new TypedField<>(BigDecimal.class, "count");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<String> UNIT = new TypedField<>(String.class, "unit");
        TypedField<LocalDateTime> START_TIME = new TypedField<>(LocalDateTime.class, "start_time");
        TypedField<LocalDateTime> END_TIME = new TypedField<>(LocalDateTime.class, "end_time");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> SERVICE_TYPE = new TypedField<>(String.class, "service_type");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface ProductAllocation {
        static Long id() {
            return 1415208799121907714L;
        }
        static String code() {
            return "productAllocation";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "product_code");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "product_name");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<LocalDateTime> TIME = new TypedField<>(LocalDateTime.class, "time");
        TypedField<String> NUMBER = new TypedField<>(String.class, "number");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface UnitPrice {
        static Long id() {
            return 1415208953767653377L;
        }
        static String code() {
            return "unitPrice";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<String> UNIT = new TypedField<>(String.class, "unit");
        TypedField<LocalDateTime> START_TIME = new TypedField<>(LocalDateTime.class, "start_time");
        TypedField<LocalDateTime> END_TIME = new TypedField<>(LocalDateTime.class, "end_time");
        TypedField<String> INPUT_WAY = new TypedField<>(String.class, "input_way");
        TypedField<Long> YEAR = new TypedField<>(Long.class, "year");
        TypedField<Long> MONTH = new TypedField<>(Long.class, "month");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface AllocationRuleDetails {
        static Long id() {
            return 1415209110972604418L;
        }
        static String code() {
            return "allocationRuleDetails";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<BigDecimal> ALLOCATION_PROPORTION = new TypedField<>(BigDecimal.class, "allocation_proportion");
        TypedField<BigDecimal> CONSUMPTION = new TypedField<>(BigDecimal.class, "consumption");
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "charge_code");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface AllocationRule {
        static Long id() {
            return 1415211734738006018L;
        }
        static String code() {
            return "allocationRule";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<String> ALLOCATION_TYPE = new TypedField<>(String.class, "allocation_type");
        TypedField<LocalDateTime> START_TIME = new TypedField<>(LocalDateTime.class, "start_time");
        TypedField<LocalDateTime> END_TIME = new TypedField<>(LocalDateTime.class, "end_time");
        TypedField<String> CHARGE_BELONG = new TypedField<>(String.class, "charge_belong");
        TypedField<Long> MONTH = new TypedField<>(Long.class, "month");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface ChargeCodeMaintain {
        static Long id() {
            return 1415212005962674177L;
        }
        static String code() {
            return "chargeCodeMaintain";
        }
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "product_name");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "product_code");
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "charge_code");
        TypedField<String> PRODUCT_PHASE = new TypedField<>(String.class, "product_phase");
        TypedField<String> CHARGE_BELONG_CODE = new TypedField<>(String.class, "charge_belong_code");
        TypedField<String> CHARGE_BELONG = new TypedField<>(String.class, "charge_belong");
        TypedField<String> SOLUTION_TYPE = new TypedField<>(String.class, "solution_type");
        TypedField<String> PROFESSION = new TypedField<>(String.class, "profession");
        TypedField<String> ACTIVITY_TYPE = new TypedField<>(String.class, "activity_type");
        TypedField<String> REGION = new TypedField<>(String.class, "region");
        TypedField<String> SALE_TEAM = new TypedField<>(String.class, "sale_team");
        TypedField<String> PROJECT_CODE = new TypedField<>(String.class, "project_code");
        TypedField<String> SOLUTION_PHASE = new TypedField<>(String.class, "solution_phase");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface InfoBI {
        static Long id() {
            return 1415212818932035585L;
        }
        static String code() {
            return "infoBI";
        }
        TypedField<String> TAX_NUMBER = new TypedField<>(String.class, "tax_number");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "product_name");
        TypedField<String> MIDDLE_GROUND_CODE = new TypedField<>(String.class, "middle_ground_code");
        TypedField<BigDecimal> AMOUNT_USAGE = new TypedField<>(BigDecimal.class, "amount_usage");
        TypedField<String> MIDDLE_GROUND_NAME = new TypedField<>(String.class, "middle_ground_name");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "product_code");
        TypedField<String> TENTANT = new TypedField<>(String.class, "tentant");
        TypedField<LocalDateTime> STARTING_TIME = new TypedField<>(LocalDateTime.class, "starting_time");
        TypedField<LocalDateTime> ENDING_TIME = new TypedField<>(LocalDateTime.class, "ending_time");
        TypedField<String> UNIT = new TypedField<>(String.class, "unit");
        TypedField<String> TENTANT_CODE = new TypedField<>(String.class, "tentant_code");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "charge_code");
        TypedField<Long> YEAR = new TypedField<>(Long.class, "year");
        TypedField<Long> MONTH = new TypedField<>(Long.class, "month");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface ServiceCostDetails {
        static Long id() {
            return 1415214963842392066L;
        }
        static String code() {
            return "serviceCostDetails";
        }
        TypedField<String> SERVICE_NAME = new TypedField<>(String.class, "service_name");
        TypedField<String> SERVICE_CODE = new TypedField<>(String.class, "service_code");
        TypedField<String> COST_CODE = new TypedField<>(String.class, "cost_code");
        TypedField<String> PRODUCT_PHASE = new TypedField<>(String.class, "product_phase");
        TypedField<String> COST_TYPE = new TypedField<>(String.class, "cost_type");
        TypedField<String> COST_BELONG = new TypedField<>(String.class, "cost_belong");
        TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "data_source");
        TypedField<LocalDateTime> OCCURENCY_TIME = new TypedField<>(LocalDateTime.class, "occurency_time");
        TypedField<String> DEPARTMENT_NAME = new TypedField<>(String.class, "department_name");
        TypedField<String> DEPARTMENT_CODE = new TypedField<>(String.class, "department_code");
        TypedField<String> DIVIDE_CODE = new TypedField<>(String.class, "divide_code");
        TypedField<String> SUBMIT_STATUS = new TypedField<>(String.class, "submit_status");
        TypedField<BigDecimal> CUMULATIVE_COST = new TypedField<>(BigDecimal.class, "cumulative_cost");
        TypedField<BigDecimal> CURRENT_COST = new TypedField<>(BigDecimal.class, "current_cost");
        TypedField<BigDecimal> CUMULATIVE_OUTPUT = new TypedField<>(BigDecimal.class, "cumulative_output");
        TypedField<BigDecimal> CURRENT_OUTPUT = new TypedField<>(BigDecimal.class, "current_output");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<String> COST_NAME = new TypedField<>(String.class, "cost_name");
        TypedField<String> PARENT_CHARGECODE = new TypedField<>(String.class, "parent_chargecode");
        TypedField<Long> ACCOUNTING_YEAR = new TypedField<>(Long.class, "accounting_year");
        TypedField<Long> ACCOUNTING_MONTH = new TypedField<>(Long.class, "accounting_month");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface ServiceCost {
        static Long id() {
            return 1415215356366331905L;
        }
        static String code() {
            return "serviceCost";
        }
        TypedField<String> SERVICE_TYPE = new TypedField<>(String.class, "service_type");
        TypedField<String> SERVICE_CODE = new TypedField<>(String.class, "service_code");
        TypedField<String> SERVICE_NAME = new TypedField<>(String.class, "service_name");
        TypedField<LocalDateTime> OCCRENCY_TIME = new TypedField<>(LocalDateTime.class, "occrency_time");
        TypedField<String> DIVIDE_CODE = new TypedField<>(String.class, "divide_code");
        TypedField<String> CURRENCY_STATUS = new TypedField<>(String.class, "currency_status");
        TypedField<BigDecimal> CUMULATIVE_COST = new TypedField<>(BigDecimal.class, "cumulative_cost");
        TypedField<BigDecimal> CURRENT_COST = new TypedField<>(BigDecimal.class, "current_cost");
        TypedField<BigDecimal> CUMULATIVE_OUTPUT = new TypedField<>(BigDecimal.class, "cumulative_output");
        TypedField<BigDecimal> CURRENT_OUTPUT = new TypedField<>(BigDecimal.class, "current_output");
        TypedField<Long> ACCOUNTING_YEAR = new TypedField<>(Long.class, "accounting_year");
        TypedField<Long> ACCOUNTING_MONTH = new TypedField<>(Long.class, "accounting_month");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<String> SRV_CODE = new TypedField<>(String.class, "srv_code");
        TypedField<String> SRV_NAME = new TypedField<>(String.class, "srv_name");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface Income {
        static Long id() {
            return 1415498206489735170L;
        }
        static String code() {
            return "income";
        }
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECTNAME = new TypedField<>(String.class, "projectName");
        TypedField<String> STATEMENTNO = new TypedField<>(String.class, "statementNo");
        TypedField<String> USECOMPANYNAME = new TypedField<>(String.class, "useCompanyName");
        TypedField<String> USECOMPANYTAXNO = new TypedField<>(String.class, "useCompanytaxNo");
        TypedField<String> PRODUCT = new TypedField<>(String.class, "product");
        TypedField<String> MODELNO = new TypedField<>(String.class, "modelNo");
        TypedField<String> PROPERTY = new TypedField<>(String.class, "property");
        TypedField<BigDecimal> UNIT = new TypedField<>(BigDecimal.class, "unit");
        TypedField<BigDecimal> RATIO = new TypedField<>(BigDecimal.class, "ratio");
        TypedField<Long> NUMBER = new TypedField<>(Long.class, "number");
        TypedField<String> CHARGEUNIT = new TypedField<>(String.class, "chargeUnit");
        TypedField<String> CHARGETYPE = new TypedField<>(String.class, "chargeType");
        TypedField<LocalDateTime> RECEIPTDATE = new TypedField<>(LocalDateTime.class, "receiptDate");
        TypedField<LocalDateTime> STARTCHARGEDATE = new TypedField<>(LocalDateTime.class, "startChargeDate");
        TypedField<LocalDateTime> ENDCHARGEDATE = new TypedField<>(LocalDateTime.class, "endChargeDate");
        TypedField<Long> USEMONTH = new TypedField<>(Long.class, "useMonth");
        TypedField<Long> USEYEAR = new TypedField<>(Long.class, "useYear");
        TypedField<BigDecimal> CURINCOME = new TypedField<>(BigDecimal.class, "curIncome");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface SettlementData {
        static Long id() {
            return 1415502111091400706L;
        }
        static String code() {
            return "settlementData";
        }
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECTNAME = new TypedField<>(String.class, "projectName");
        TypedField<String> STATEMENTNO = new TypedField<>(String.class, "statementNo");
        TypedField<String> USECOMPANYNAME = new TypedField<>(String.class, "useCompanyName");
        TypedField<String> USECOMPANYTAX = new TypedField<>(String.class, "useCompanyTax");
        TypedField<String> PRODUCT = new TypedField<>(String.class, "product");
        TypedField<String> TYPE = new TypedField<>(String.class, "type");
        TypedField<String> CHARGETYPE = new TypedField<>(String.class, "chargeType");
        TypedField<String> NATURE = new TypedField<>(String.class, "nature");
        TypedField<BigDecimal> UNITPRICEWITHOUTTAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<BigDecimal> TAXRATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> COUNT = new TypedField<>(BigDecimal.class, "count");
        TypedField<String> CHARGEUNIT = new TypedField<>(String.class, "chargeUnit");
        TypedField<String> INCOMETYPE = new TypedField<>(String.class, "incomeType");
        TypedField<LocalDateTime> CHECKDATE = new TypedField<>(LocalDateTime.class, "checkDate");
        TypedField<String> CYCLE = new TypedField<>(String.class, "cycle");
        TypedField<LocalDateTime> SETTLEMENTSTARTDATE = new TypedField<>(LocalDateTime.class, "settlementStartDate");
        TypedField<LocalDateTime> SETTLEMENTENDDATE = new TypedField<>(LocalDateTime.class, "settlementEndDate");
        TypedField<LocalDateTime> STATEMENTCREATEDATE = new TypedField<>(LocalDateTime.class, "statementCreateDate");
        TypedField<BigDecimal> ALLSETTLEMENTAMOUNTWITHOUTTAX = new TypedField<>(BigDecimal.class, "allSettlementAmountWithoutTax");
        TypedField<BigDecimal> ALLSETTLEMENTAMOUNTWITHTAX = new TypedField<>(BigDecimal.class, "allSettlementAmountWithTax");
        TypedField<String> INVOICECOMPANYNAME = new TypedField<>(String.class, "invoiceCompanyName");
        TypedField<String> INVOICECOMPANYTAX = new TypedField<>(String.class, "invoiceCompanyTax");
        TypedField<LocalDateTime> INVOICEDATE = new TypedField<>(LocalDateTime.class, "invoiceDate");
        TypedField<BigDecimal> INVOICEAMOUNTWITHOUTTAX = new TypedField<>(BigDecimal.class, "invoiceAmountWithoutTax");
        TypedField<BigDecimal> INVOICEAMOUNTWITHTAX = new TypedField<>(BigDecimal.class, "invoiceAmountWithTax");
        TypedField<LocalDateTime> PAYMENTDATE = new TypedField<>(LocalDateTime.class, "paymentDate");
        TypedField<BigDecimal> PAYMENTAMOUNT = new TypedField<>(BigDecimal.class, "paymentAmount");
        TypedField<String> PAYMENTCOMPANY = new TypedField<>(String.class, "paymentCompany");
        TypedField<String> STATEMENTSTATUS = new TypedField<>(String.class, "statementStatus");
        TypedField<String> INVOICESTATUS = new TypedField<>(String.class, "invoiceStatus");
        TypedField<String> PAYMENTSTATUS = new TypedField<>(String.class, "paymentStatus");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface CapitalJournal {
        static Long id() {
            return 1415504437306925057L;
        }
        static String code() {
            return "capitalJournal";
        }
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> INVOICECODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICENO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> BILLNO = new TypedField<>(String.class, "billNo");
        TypedField<String> PROJECTCODE = new TypedField<>(String.class, "projectCode");
        TypedField<String> PROJECTNAME = new TypedField<>(String.class, "projectName");
        TypedField<String> PRODUCTCODE = new TypedField<>(String.class, "productCode");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<String> PRODUCTMODEL = new TypedField<>(String.class, "productModel");
        TypedField<String> USEPURCHASERNAME = new TypedField<>(String.class, "usePurchaserName");
        TypedField<String> USEPURCHASERTAXID = new TypedField<>(String.class, "usePurchaserTaxID");
        TypedField<String> INVOICEPURCHASERNAME = new TypedField<>(String.class, "invoicePurchaserName");
        TypedField<String> INVOICEPURCHASERTAX = new TypedField<>(String.class, "invoicePurchaserTax");
        TypedField<String> INVOICEPURCHASERPHONE = new TypedField<>(String.class, "invoicePurchaserPhone");
        TypedField<String> INVOICEPURCHASERADDR = new TypedField<>(String.class, "invoicePurchaserAddr");
        TypedField<String> INVOICEPURCHASERACCOUNT = new TypedField<>(String.class, "invoicePurchaserAccount");
        TypedField<String> INVOICEPURCHASERBANK = new TypedField<>(String.class, "invoicePurchaserBank");
        TypedField<LocalDateTime> INVOICEDATE = new TypedField<>(LocalDateTime.class, "invoiceDate");
        TypedField<BigDecimal> PAYBACKMONEY = new TypedField<>(BigDecimal.class, "paybackMoney");
        TypedField<BigDecimal> PAYMENTAMOUNT = new TypedField<>(BigDecimal.class, "paymentAmount");
        TypedField<BigDecimal> NETPAYMENT = new TypedField<>(BigDecimal.class, "netPayment");
        TypedField<BigDecimal> SETTLEMENTAMOUNTTAX = new TypedField<>(BigDecimal.class, "settlementAmountTax");
        TypedField<BigDecimal> INVOICEAMOUNT = new TypedField<>(BigDecimal.class, "invoiceAmount");
        TypedField<BigDecimal> INVOICEAMOUNTTAX = new TypedField<>(BigDecimal.class, "invoiceAmountTax");
        TypedField<String> TAXED = new TypedField<>(String.class, "taxEd");
        TypedField<BigDecimal> TAXRATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> TAXAMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<String> GOODSNAME = new TypedField<>(String.class, "goodsName");
        TypedField<String> SETTLEMENTCONDITION = new TypedField<>(String.class, "settlementCondition");
        TypedField<String> PAYMENTBANKACCOUNT = new TypedField<>(String.class, "paymentBankAccount");
        TypedField<String> PAYMENTBANKNAME = new TypedField<>(String.class, "paymentBankName");
        TypedField<LocalDateTime> APPOINTPAYMENTDATE = new TypedField<>(LocalDateTime.class, "appointPaymentDate");
        TypedField<LocalDateTime> PAYMENTDATE = new TypedField<>(LocalDateTime.class, "paymentDate");
        TypedField<String> BILLINGTYPE = new TypedField<>(String.class, "billingType");
        TypedField<String> SIGNTEAM = new TypedField<>(String.class, "signTeam");
        TypedField<String> PAYMENTNATURE = new TypedField<>(String.class, "paymentNature");
        TypedField<LocalDateTime> SETTLEMENTSTARTDATE = new TypedField<>(LocalDateTime.class, "settlementStartDate");
        TypedField<LocalDateTime> SETTLEMENTENDDATE = new TypedField<>(LocalDateTime.class, "settlementEndDate");
        TypedField<String> MAPPINGSTATUS = new TypedField<>(String.class, "mappingStatus");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface Contract {
        static Long id() {
            return 1415514648138260481L;
        }
        static String code() {
            return "contract";
        }
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECTNO = new TypedField<>(String.class, "projectNo");
        TypedField<String> PROJECTNAME = new TypedField<>(String.class, "projectName");
        TypedField<String> GROUPNO = new TypedField<>(String.class, "groupNo");
        TypedField<String> SIGNTEAM = new TypedField<>(String.class, "signTeam");
        TypedField<String> SIGNATORYNAME = new TypedField<>(String.class, "signatoryName");
        TypedField<String> PERIODPROMISE = new TypedField<>(String.class, "periodPromise");
        TypedField<String> EXPENSEBEARER = new TypedField<>(String.class, "expenseBearer");
        TypedField<Long> PAYMENTPERIOD = new TypedField<>(Long.class, "paymentPeriod");
        TypedField<String> PAYMENTPERIODTYPE = new TypedField<>(String.class, "paymentPeriodType");
        TypedField<LocalDateTime> SIGNDATE = new TypedField<>(LocalDateTime.class, "signDate");
        TypedField<LocalDateTime> EFFECTSTARTTIME = new TypedField<>(LocalDateTime.class, "effectStartTime");
        TypedField<LocalDateTime> EFFECTENDTIME = new TypedField<>(LocalDateTime.class, "effectEndTime");
        TypedField<BigDecimal> AMOUNTWITHTAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<String> KAM = new TypedField<>(String.class, "kam");
        TypedField<String> SIGNBUYERTEL = new TypedField<>(String.class, "signBuyerTel");
        TypedField<String> SIGNBUYEREMAIL = new TypedField<>(String.class, "signBuyerEmail");
        TypedField<String> SIGNBUYERBANKACCOUNT = new TypedField<>(String.class, "signBuyerBankAccount");
        TypedField<String> SIGNBUYERBANKNAME = new TypedField<>(String.class, "signBuyerBankName");
        TypedField<String> SIGNBUYERADDRESS = new TypedField<>(String.class, "signBuyerAddress");
        TypedField<String> SIGNBUYERTAXNO = new TypedField<>(String.class, "signBuyerTaxNo");
        TypedField<String> SIGNBUYERNAME = new TypedField<>(String.class, "signBuyerName");
        TypedField<String> SIGNTAXNOINVOICETYPE = new TypedField<>(String.class, "signTaxNoInvoiceType");
        TypedField<String> RECEIVERTEL = new TypedField<>(String.class, "receiverTel");
        TypedField<String> RECEIVERPOSTCODE = new TypedField<>(String.class, "receiverPostcode");
        TypedField<String> RECEIVERADDRESS = new TypedField<>(String.class, "receiverAddress");
        TypedField<String> RECEIVERNAME = new TypedField<>(String.class, "receiverName");
        TypedField<String> CONTRACTRECORDNO = new TypedField<>(String.class, "contractRecordNo");
        TypedField<String> PURCHASECONTRACTNO = new TypedField<>(String.class, "purchaseContractNo");
        TypedField<LocalDateTime> RECEIPTSIGNDATE = new TypedField<>(LocalDateTime.class, "receiptSignDate");
        TypedField<String> CHARGESTARTCONDITION = new TypedField<>(String.class, "chargeStartCondition");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRODUCTNO = new TypedField<>(String.class, "productNo");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<String> PRODUCTTYPE = new TypedField<>(String.class, "productType");
        TypedField<String> FUNCTIONTYPE = new TypedField<>(String.class, "functionType");
        TypedField<String> FUNTIONDESC = new TypedField<>(String.class, "funtionDesc");
        TypedField<BigDecimal> TAXRATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<String> PRODUCTSRVNAME = new TypedField<>(String.class, "productSrvName");
        TypedField<String> TAXED = new TypedField<>(String.class, "taxEd");
        TypedField<String> INVOICEUNIT = new TypedField<>(String.class, "invoiceUnit");
        TypedField<String> USEINVOICETYPE = new TypedField<>(String.class, "useInvoiceType");
        TypedField<String> INCOMETYPE = new TypedField<>(String.class, "incomeType");
        TypedField<LocalDateTime> SRVSTARTDATE = new TypedField<>(LocalDateTime.class, "srvStartDate");
        TypedField<LocalDateTime> SRVENDDATE = new TypedField<>(LocalDateTime.class, "srvEndDate");
    }

    public interface Project {
        static Long id() {
            return 1415517014084415490L;
        }
        static String code() {
            return "project";
        }
        TypedField<String> PROJECTNAME = new TypedField<>(String.class, "projectName");
        TypedField<String> PROJECTNO = new TypedField<>(String.class, "projectNo");
        TypedField<String> SALEDIRECTOREMAIL = new TypedField<>(String.class, "saleDirectorEmail");
        TypedField<String> SALEDIRECTOR = new TypedField<>(String.class, "saleDirector");
        TypedField<String> EMAIL = new TypedField<>(String.class, "email");
        TypedField<String> SALEPRINCIPAL = new TypedField<>(String.class, "salePrincipal");
        TypedField<String> SIGNTEAM = new TypedField<>(String.class, "signTeam");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface ProductFunction {
        static Long id() {
            return 1415519149595336706L;
        }
        static String code() {
            return "productFunction";
        }
        TypedField<String> PRODUCTNO = new TypedField<>(String.class, "productNo");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<String> PRODUCTTYPE = new TypedField<>(String.class, "productType");
        TypedField<String> FUNCTIONTYPE = new TypedField<>(String.class, "functionType");
        TypedField<String> FUNTIONDESC = new TypedField<>(String.class, "funtionDesc");
        TypedField<BigDecimal> TAXRATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<String> PRODUCTSRVNAME = new TypedField<>(String.class, "productSrvName");
        TypedField<String> TAXED = new TypedField<>(String.class, "taxEd");
        TypedField<String> INVOICEUNIT = new TypedField<>(String.class, "invoiceUnit");
        TypedField<String> USEINVOICETYPE = new TypedField<>(String.class, "useInvoiceType");
        TypedField<String> INCOMETYPE = new TypedField<>(String.class, "incomeType");
        TypedField<String> AGREEMENTCONTRACTNO = new TypedField<>(String.class, "agreementContractNo");
        TypedField<LocalDateTime> SRVSTARTDATE = new TypedField<>(LocalDateTime.class, "srvStartDate");
        TypedField<LocalDateTime> SRVENDDATE = new TypedField<>(LocalDateTime.class, "srvEndDate");
        TypedField<String> CREATEUSER = new TypedField<>(String.class, "createUser");
        TypedField<String> UPDATEUSER = new TypedField<>(String.class, "updateUser");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface IncomeMainMsg {
        static Long id() {
            return 1415957144165621761L;
        }
        static String code() {
            return "incomeMainMsg";
        }
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<String> TENANT = new TypedField<>(String.class, "tenant");
        TypedField<String> GROUPNAME = new TypedField<>(String.class, "groupName");
        TypedField<LocalDateTime> STARTCHARGETIME = new TypedField<>(LocalDateTime.class, "startChargeTime");
        TypedField<LocalDateTime> STOPCHARGETIME = new TypedField<>(LocalDateTime.class, "stopChargeTime");
        TypedField<BigDecimal> INCOMETOTALMONEY = new TypedField<>(BigDecimal.class, "incomeTotalMoney");
        TypedField<String> CHARGEDIMENSION = new TypedField<>(String.class, "chargeDimension");
        TypedField<String> DETAILSTATUS = new TypedField<>(String.class, "detailStatus");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> INCOMETYPE = new TypedField<>(String.class, "incomeType");
    }

    public interface ChargeJob {
        static Long id() {
            return 1416945394439102465L;
        }
        static String code() {
            return "chargeJob";
        }
        TypedField<LocalDateTime> CHARGESTARTDATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<String> WARRANTY = new TypedField<>(String.class, "warranty");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<LocalDateTime> AGREEONTIME = new TypedField<>(LocalDateTime.class, "agreeOnTime");
        TypedField<String> INCOMEMAINMSGID = new TypedField<>(String.class, "incomeMainMsgId");
        TypedField<String> JOBTYPE = new TypedField<>(String.class, "jobType");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> CHARGEENDDATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
    }

}
