package com.xforceplus.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 签约税号发票类型
 * </p>
 *
 * @author ultraman
 * @since 2021-10-21
 */
public enum SignInvoiceType {

    S("s", "增值税专用发票"),
    SE("se", "增值税专用电子发票"),
    C("c", "增值税普通发票"),
    CE("ce", "增值税普通电子发票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SignInvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SignInvoiceType fromCode(String code){
        switch(code) {
            case "s":
                return S;
            case "se":
                return SE;
            case "c":
                return C;
            case "ce":
                return CE;
            default:
                return null;
        }
    }
}
