package com.xforceplus.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 计费元数据
 * </p>
 *
 * @author ultraman
 * @since 2021-11-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ChargeMetaData implements Serializable {

  private static final long serialVersionUID=1L;

  @TableField("contractNo")
  private String contractNo;

  @TableField("taxNo")
  private String taxNo;

  @TableField("chargeStartDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime chargeStartDate;

  @TableField("chargeEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime chargeEndDate;

  @TableField("chargeDimension")
  private String chargeDimension;

  @TableField("productName")
  private String productName;

  @TableField("companyName")
  private String companyName;

  private String cycle;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  @TableField("chargeItem")
  private String chargeItem;

  @TableField("chargeWaterCode")
  private String chargeWaterCode;

  @TableField("chargeLabel")
  private String chargeLabel;

  @TableField("chargeMoneyWithoutTax")
  private BigDecimal chargeMoneyWithoutTax;

  @TableField("taxRate")
  private BigDecimal taxRate;

  @TableField("actualUsage")
  private BigDecimal actualUsage;

  @TableField("createDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createDate;

  @TableField("usingMonth")
  private Long usingMonth;

  @TableField("unitPriceWithoutTax")
  private BigDecimal unitPriceWithoutTax;

  @TableField("modifyTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime modifyTime;

  @TableField("chargeType")
  private String chargeType;

  @TableField("generateStatus")
  private String generateStatus;

  @TableField("isWaranty")
  private String isWaranty;

  @TableField("limitAmount")
  private BigDecimal limitAmount;

  @TableField("productCode")
  private String productCode;

  @TableField("tenantName")
  private String tenantName;

  @TableField("companyId")
  private String companyId;

  @TableField("reconcilationCode")
  private String reconcilationCode;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("contractNo", contractNo);
      map.put("taxNo", taxNo);
      map.put("chargeStartDate", BocpGenUtils.toTimestamp(chargeStartDate));
      map.put("chargeEndDate", BocpGenUtils.toTimestamp(chargeEndDate));
      map.put("chargeDimension", chargeDimension);
      map.put("productName", productName);
      map.put("companyName", companyName);
      map.put("cycle", cycle);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("chargeItem", chargeItem);
      map.put("chargeWaterCode", chargeWaterCode);
      map.put("chargeLabel", chargeLabel);
      map.put("chargeMoneyWithoutTax", chargeMoneyWithoutTax);
      map.put("taxRate", taxRate);
      map.put("actualUsage", actualUsage);
      map.put("createDate", BocpGenUtils.toTimestamp(createDate));
      map.put("usingMonth", usingMonth);
      map.put("unitPriceWithoutTax", unitPriceWithoutTax);
      map.put("modifyTime", BocpGenUtils.toTimestamp(modifyTime));
      map.put("chargeType", chargeType);
      map.put("generateStatus", generateStatus);
      map.put("isWaranty", isWaranty);
      map.put("limitAmount", limitAmount);
      map.put("productCode", productCode);
      map.put("tenantName", tenantName);
      map.put("companyId", companyId);
      map.put("reconcilationCode", reconcilationCode);
      return map;
  }

  public static ChargeMetaData fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ChargeMetaData entity = new ChargeMetaData();
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxNo")) {
      Object obj = map.get("taxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeStartDate")) {
      Object obj = map.get("chargeStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setChargeStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setChargeStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setChargeStartDate(null);
      }
    }
    if(map.containsKey("chargeEndDate")) {
      Object obj = map.get("chargeEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setChargeEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setChargeEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setChargeEndDate(null);
      }
    }
    if(map.containsKey("chargeDimension")) {
      Object obj = map.get("chargeDimension");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeDimension((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cycle")) {
      Object obj = map.get("cycle");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCycle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeItem")) {
      Object obj = map.get("chargeItem");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeWaterCode")) {
      Object obj = map.get("chargeWaterCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeWaterCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeLabel")) {
      Object obj = map.get("chargeLabel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeLabel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeMoneyWithoutTax")) {
      Object obj = map.get("chargeMoneyWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setChargeMoneyWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setChargeMoneyWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setChargeMoneyWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setChargeMoneyWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setChargeMoneyWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("actualUsage")) {
      Object obj = map.get("actualUsage");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setActualUsage((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setActualUsage(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setActualUsage(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setActualUsage(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setActualUsage(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("createDate")) {
      Object obj = map.get("createDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateDate(null);
      }
    }
    if(map.containsKey("usingMonth")) {
      Object obj = map.get("usingMonth");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUsingMonth((Long)obj);
        } else if(obj instanceof String) {
          entity.setUsingMonth(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUsingMonth(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceWithoutTax")) {
      Object obj = map.get("unitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("modifyTime")) {
      Object obj = map.get("modifyTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setModifyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setModifyTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setModifyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setModifyTime(null);
      }
    }
    if(map.containsKey("chargeType")) {
      Object obj = map.get("chargeType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("generateStatus")) {
      Object obj = map.get("generateStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGenerateStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isWaranty")) {
      Object obj = map.get("isWaranty");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsWaranty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("limitAmount")) {
      Object obj = map.get("limitAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setLimitAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setLimitAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setLimitAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setLimitAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLimitAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenantName")) {
      Object obj = map.get("tenantName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyId")) {
      Object obj = map.get("companyId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reconcilationCode")) {
      Object obj = map.get("reconcilationCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReconcilationCode((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
