package com.xforceplus.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 合同主信息
 * </p>
 *
 * @author ultraman
 * @since 2021-11-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Contract implements Serializable {

  private static final long serialVersionUID=1L;

  @TableField("contractNo")
  private String contractNo;

  @TableField("projectNo")
  private String projectNo;

  @TableField("projectName")
  private String projectName;

  @TableField("signTeam")
  private String signTeam;

  @TableField("signatoryName")
  private String signatoryName;

  @TableField("periodPromise")
  private String periodPromise;

  @TableField("paymentPeriod")
  private Long paymentPeriod;

  @TableField("paymentPeriodType")
  private String paymentPeriodType;

  @TableField("signDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime signDate;

  @TableField("effectStartTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime effectStartTime;

  @TableField("receiptSignDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime receiptSignDate;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  @TableField("containsRetentionMoney")
  private String containsRetentionMoney;

  @TableField("chargeCode")
  private String chargeCode;

  @TableField("contractExpiryDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime contractExpiryDate;

  @TableField("contractType")
  private String contractType;

  @TableField("contractTotalMoney")
  private BigDecimal contractTotalMoney;

  @TableField("tenantName")
  private String tenantName;

  private String customer;

  @TableField("businessUnit")
  private String businessUnit;

  @TableField("principalPerson")
  private String principalPerson;

  @TableField("tenantGroupId")
  private Long tenantGroupId;

  @TableField("chargeContractId")
  private String chargeContractId;

  private String region;

  @TableField("regionId")
  private String regionId;

  @TableField("saChargeCode")
  private String saChargeCode;

  @TableField("saChargeCodeName")
  private String saChargeCodeName;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("contractNo", contractNo);
      map.put("projectNo", projectNo);
      map.put("projectName", projectName);
      map.put("signTeam", signTeam);
      map.put("signatoryName", signatoryName);
      map.put("periodPromise", periodPromise);
      map.put("paymentPeriod", paymentPeriod);
      map.put("paymentPeriodType", paymentPeriodType);
      map.put("signDate", BocpGenUtils.toTimestamp(signDate));
      map.put("effectStartTime", BocpGenUtils.toTimestamp(effectStartTime));
      map.put("receiptSignDate", BocpGenUtils.toTimestamp(receiptSignDate));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("containsRetentionMoney", containsRetentionMoney);
      map.put("chargeCode", chargeCode);
      map.put("contractExpiryDate", BocpGenUtils.toTimestamp(contractExpiryDate));
      map.put("contractType", contractType);
      map.put("contractTotalMoney", contractTotalMoney);
      map.put("tenantName", tenantName);
      map.put("customer", customer);
      map.put("businessUnit", businessUnit);
      map.put("principalPerson", principalPerson);
      map.put("tenantGroupId", tenantGroupId);
      map.put("chargeContractId", chargeContractId);
      map.put("region", region);
      map.put("regionId", regionId);
      map.put("saChargeCode", saChargeCode);
      map.put("saChargeCodeName", saChargeCodeName);
      return map;
  }

  public static Contract fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Contract entity = new Contract();
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectNo")) {
      Object obj = map.get("projectNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signTeam")) {
      Object obj = map.get("signTeam");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignTeam((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signatoryName")) {
      Object obj = map.get("signatoryName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignatoryName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("periodPromise")) {
      Object obj = map.get("periodPromise");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPeriodPromise((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentPeriod")) {
      Object obj = map.get("paymentPeriod");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaymentPeriod((Long)obj);
        } else if(obj instanceof String) {
          entity.setPaymentPeriod(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPaymentPeriod(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("paymentPeriodType")) {
      Object obj = map.get("paymentPeriodType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentPeriodType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signDate")) {
      Object obj = map.get("signDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSignDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSignDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSignDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSignDate(null);
      }
    }
    if(map.containsKey("effectStartTime")) {
      Object obj = map.get("effectStartTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEffectStartTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEffectStartTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setEffectStartTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEffectStartTime(null);
      }
    }
    if(map.containsKey("receiptSignDate")) {
      Object obj = map.get("receiptSignDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReceiptSignDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReceiptSignDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setReceiptSignDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReceiptSignDate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("containsRetentionMoney")) {
      Object obj = map.get("containsRetentionMoney");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContainsRetentionMoney((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeCode")) {
      Object obj = map.get("chargeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractExpiryDate")) {
      Object obj = map.get("contractExpiryDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setContractExpiryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setContractExpiryDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setContractExpiryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setContractExpiryDate(null);
      }
    }
    if(map.containsKey("contractType")) {
      Object obj = map.get("contractType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractTotalMoney")) {
      Object obj = map.get("contractTotalMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setContractTotalMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setContractTotalMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setContractTotalMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setContractTotalMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setContractTotalMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tenantName")) {
      Object obj = map.get("tenantName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer")) {
      Object obj = map.get("customer");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessUnit")) {
      Object obj = map.get("businessUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("principalPerson")) {
      Object obj = map.get("principalPerson");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrincipalPerson((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenantGroupId")) {
      Object obj = map.get("tenantGroupId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantGroupId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantGroupId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("chargeContractId")) {
      Object obj = map.get("chargeContractId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeContractId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("region")) {
      Object obj = map.get("region");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRegion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionId")) {
      Object obj = map.get("regionId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRegionId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("saChargeCode")) {
      Object obj = map.get("saChargeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSaChargeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("saChargeCodeName")) {
      Object obj = map.get("saChargeCodeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSaChargeCodeName((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
