package com.xforceplus.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 支付流水
 * </p>
 *
 * @author ultraman
 * @since 2021-11-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PayWater implements Serializable {

  private static final long serialVersionUID=1L;

  @TableField("tradeTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime tradeTime;

  @TableField("debitMoneyAmount")
  private BigDecimal debitMoneyAmount;

  @TableField("creditMoneyAmount")
  private BigDecimal creditMoneyAmount;

  @TableField("bankName")
  private String bankName;

  @TableField("bankAccount")
  private String bankAccount;

  @TableField("openAccountInstitutions")
  private String openAccountInstitutions;

  @TableField("tradeNo")
  private String tradeNo;

  private String remark;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("tradeTime", BocpGenUtils.toTimestamp(tradeTime));
      map.put("debitMoneyAmount", debitMoneyAmount);
      map.put("creditMoneyAmount", creditMoneyAmount);
      map.put("bankName", bankName);
      map.put("bankAccount", bankAccount);
      map.put("openAccountInstitutions", openAccountInstitutions);
      map.put("tradeNo", tradeNo);
      map.put("remark", remark);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static PayWater fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PayWater entity = new PayWater();
    if(map.containsKey("tradeTime")) {
      Object obj = map.get("tradeTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTradeTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setTradeTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setTradeTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTradeTime(null);
      }
    }
    if(map.containsKey("debitMoneyAmount")) {
      Object obj = map.get("debitMoneyAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDebitMoneyAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDebitMoneyAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDebitMoneyAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setDebitMoneyAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDebitMoneyAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("creditMoneyAmount")) {
      Object obj = map.get("creditMoneyAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCreditMoneyAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCreditMoneyAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCreditMoneyAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCreditMoneyAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreditMoneyAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bankName")) {
      Object obj = map.get("bankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bankAccount")) {
      Object obj = map.get("bankAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("openAccountInstitutions")) {
      Object obj = map.get("openAccountInstitutions");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOpenAccountInstitutions((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tradeNo")) {
      Object obj = map.get("tradeNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTradeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
