package com.xforceplus.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 结算统计明细表
 * </p>
 *
 * @author ultraman
 * @since 2021-11-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SettlementData implements Serializable {

  private static final long serialVersionUID=1L;

  @TableField("contractNo")
  private String contractNo;

  @TableField("projectName")
  private String projectName;

  @TableField("statementNo")
  private String statementNo;

  @TableField("chargeType")
  private String chargeType;

  @TableField("unitPriceWithoutTax")
  private BigDecimal unitPriceWithoutTax;

  @TableField("taxRate")
  private BigDecimal taxRate;

  @TableField("chargeUnit")
  private String chargeUnit;

  @TableField("statementCreateDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime statementCreateDate;

  @TableField("invoiceCompanyName")
  private String invoiceCompanyName;

  @TableField("invoiceCompanyTax")
  private String invoiceCompanyTax;

  @TableField("invoiceDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime invoiceDate;

  @TableField("invoiceAmountWithoutTax")
  private BigDecimal invoiceAmountWithoutTax;

  @TableField("invoiceAmountWithTax")
  private BigDecimal invoiceAmountWithTax;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  private String property;

  @TableField("companyName")
  private String companyName;

  @TableField("companyTax")
  private String companyTax;

  @TableField("productName")
  private String productName;

  @TableField("chargeMethod")
  private String chargeMethod;

  @TableField("acceptanceDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime acceptanceDate;

  @TableField("chargeStartDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime chargeStartDate;

  @TableField("chargeEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime chargeEndDate;

  @TableField("chargeMoneyWithoutTax")
  private BigDecimal chargeMoneyWithoutTax;

  @TableField("chargeMoneyWithTax")
  private BigDecimal chargeMoneyWithTax;

  @TableField("returnDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime returnDate;

  @TableField("returnMoney")
  private BigDecimal returnMoney;

  @TableField("payerCompany")
  private String payerCompany;

  @TableField("currentStatus")
  private String currentStatus;

  @TableField("chargeCycle")
  private String chargeCycle;

  private BigDecimal amount;

  @TableField("chargeDays")
  private Long chargeDays;

  @TableField("currentDiscountMoneyWithTax")
  private BigDecimal currentDiscountMoneyWithTax;

  @TableField("discountLaterMoneyWithTax")
  private BigDecimal discountLaterMoneyWithTax;

  @TableField("discountLaterMoneyWithoutTax")
  private BigDecimal discountLaterMoneyWithoutTax;

  @TableField("orderNo")
  private String orderNo;

  @TableField("orderGenerateDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime orderGenerateDate;

  @TableField("paymentRequirement")
  private String paymentRequirement;

  @TableField("productCode")
  private String productCode;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("contractNo", contractNo);
      map.put("projectName", projectName);
      map.put("statementNo", statementNo);
      map.put("chargeType", chargeType);
      map.put("unitPriceWithoutTax", unitPriceWithoutTax);
      map.put("taxRate", taxRate);
      map.put("chargeUnit", chargeUnit);
      map.put("statementCreateDate", BocpGenUtils.toTimestamp(statementCreateDate));
      map.put("invoiceCompanyName", invoiceCompanyName);
      map.put("invoiceCompanyTax", invoiceCompanyTax);
      map.put("invoiceDate", BocpGenUtils.toTimestamp(invoiceDate));
      map.put("invoiceAmountWithoutTax", invoiceAmountWithoutTax);
      map.put("invoiceAmountWithTax", invoiceAmountWithTax);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("property", property);
      map.put("companyName", companyName);
      map.put("companyTax", companyTax);
      map.put("productName", productName);
      map.put("chargeMethod", chargeMethod);
      map.put("acceptanceDate", BocpGenUtils.toTimestamp(acceptanceDate));
      map.put("chargeStartDate", BocpGenUtils.toTimestamp(chargeStartDate));
      map.put("chargeEndDate", BocpGenUtils.toTimestamp(chargeEndDate));
      map.put("chargeMoneyWithoutTax", chargeMoneyWithoutTax);
      map.put("chargeMoneyWithTax", chargeMoneyWithTax);
      map.put("returnDate", BocpGenUtils.toTimestamp(returnDate));
      map.put("returnMoney", returnMoney);
      map.put("payerCompany", payerCompany);
      map.put("currentStatus", currentStatus);
      map.put("chargeCycle", chargeCycle);
      map.put("amount", amount);
      map.put("chargeDays", chargeDays);
      map.put("currentDiscountMoneyWithTax", currentDiscountMoneyWithTax);
      map.put("discountLaterMoneyWithTax", discountLaterMoneyWithTax);
      map.put("discountLaterMoneyWithoutTax", discountLaterMoneyWithoutTax);
      map.put("orderNo", orderNo);
      map.put("orderGenerateDate", BocpGenUtils.toTimestamp(orderGenerateDate));
      map.put("paymentRequirement", paymentRequirement);
      map.put("productCode", productCode);
      return map;
  }

  public static SettlementData fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    SettlementData entity = new SettlementData();
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("statementNo")) {
      Object obj = map.get("statementNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeType")) {
      Object obj = map.get("chargeType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceWithoutTax")) {
      Object obj = map.get("unitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("chargeUnit")) {
      Object obj = map.get("chargeUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("statementCreateDate")) {
      Object obj = map.get("statementCreateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStatementCreateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStatementCreateDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setStatementCreateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStatementCreateDate(null);
      }
    }
    if(map.containsKey("invoiceCompanyName")) {
      Object obj = map.get("invoiceCompanyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCompanyTax")) {
      Object obj = map.get("invoiceCompanyTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCompanyTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceDate")) {
      Object obj = map.get("invoiceDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setInvoiceDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInvoiceDate(null);
      }
    }
    if(map.containsKey("invoiceAmountWithoutTax")) {
      Object obj = map.get("invoiceAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInvoiceAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmountWithTax")) {
      Object obj = map.get("invoiceAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInvoiceAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("property")) {
      Object obj = map.get("property");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProperty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyTax")) {
      Object obj = map.get("companyTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeMethod")) {
      Object obj = map.get("chargeMethod");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("acceptanceDate")) {
      Object obj = map.get("acceptanceDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAcceptanceDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAcceptanceDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAcceptanceDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAcceptanceDate(null);
      }
    }
    if(map.containsKey("chargeStartDate")) {
      Object obj = map.get("chargeStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setChargeStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setChargeStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setChargeStartDate(null);
      }
    }
    if(map.containsKey("chargeEndDate")) {
      Object obj = map.get("chargeEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setChargeEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setChargeEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setChargeEndDate(null);
      }
    }
    if(map.containsKey("chargeMoneyWithoutTax")) {
      Object obj = map.get("chargeMoneyWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setChargeMoneyWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setChargeMoneyWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setChargeMoneyWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setChargeMoneyWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setChargeMoneyWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("chargeMoneyWithTax")) {
      Object obj = map.get("chargeMoneyWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setChargeMoneyWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setChargeMoneyWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setChargeMoneyWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setChargeMoneyWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setChargeMoneyWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("returnDate")) {
      Object obj = map.get("returnDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReturnDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReturnDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setReturnDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReturnDate(null);
      }
    }
    if(map.containsKey("returnMoney")) {
      Object obj = map.get("returnMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReturnMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReturnMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReturnMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setReturnMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReturnMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("payerCompany")) {
      Object obj = map.get("payerCompany");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayerCompany((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currentStatus")) {
      Object obj = map.get("currentStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeCycle")) {
      Object obj = map.get("chargeCycle");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeCycle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("chargeDays")) {
      Object obj = map.get("chargeDays");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeDays((Long)obj);
        } else if(obj instanceof String) {
          entity.setChargeDays(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setChargeDays(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("currentDiscountMoneyWithTax")) {
      Object obj = map.get("currentDiscountMoneyWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCurrentDiscountMoneyWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCurrentDiscountMoneyWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCurrentDiscountMoneyWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCurrentDiscountMoneyWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCurrentDiscountMoneyWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountLaterMoneyWithTax")) {
      Object obj = map.get("discountLaterMoneyWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountLaterMoneyWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountLaterMoneyWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountLaterMoneyWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setDiscountLaterMoneyWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountLaterMoneyWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountLaterMoneyWithoutTax")) {
      Object obj = map.get("discountLaterMoneyWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountLaterMoneyWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountLaterMoneyWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountLaterMoneyWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setDiscountLaterMoneyWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountLaterMoneyWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderGenerateDate")) {
      Object obj = map.get("orderGenerateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderGenerateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setOrderGenerateDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setOrderGenerateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOrderGenerateDate(null);
      }
    }
    if(map.containsKey("paymentRequirement")) {
      Object obj = map.get("paymentRequirement");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentRequirement((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
