package com.xforceplus.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * chargeCode类型
 * </p>
 *
 * @author ultraman
 * @since 2021-11-25
 */
public enum ChargeCodeTypeEnum {

    SA("SA", "客户"),
    PS("PS", "机会"),
    DL("DL", "项目"),
    CSM("CSM", "客户成功");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ChargeCodeTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeCodeTypeEnum fromCode(String code){
        switch(code) {
            case "SA":
                return SA;
            case "PS":
                return PS;
            case "DL":
                return DL;
            case "CSM":
                return CSM;
            default:
                return null;
        }
    }
}
