package com.xforceplus.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 收费方式
 * </p>
 *
 * @author ultraman
 * @since 2021-12-09
 */
public enum ChargeType {

    PRE_PAID("prePaid", "预付"),
    POST_PAID("postPaid", "后付"),
    CONTRACT_PAID("contractPaid", "按合同付");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ChargeType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeType fromCode(String code){
        switch(code) {
            case "prePaid":
                return PRE_PAID;
            case "postPaid":
                return POST_PAID;
            case "contractPaid":
                return CONTRACT_PAID;
            default:
                return null;
        }
    }
}
