package com.xforceplus.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 合同有效期约定
 * </p>
 *
 * @author ultraman
 * @since 2021-12-09
 */
public enum ContractAppoint {

    _0("0", "未约定"),
    _1("1", "单次合同，无延续"),
    _2("2", "有期限的延续"),
    _3("3", "无期限，未明确是否延续"),
    _4("4", "有期限，不延续"),
    _5("5", "无期限，无书面异议自动延续"),
    _6("6", "有期限，未明确是否延续"),
    _7("7", "有期限，无书面异议自动延续");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ContractAppoint(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ContractAppoint fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            default:
                return null;
        }
    }
}
